import json
from redis import Redis
from functools import wraps
from paxd.app.msg import PRequest

redis = Redis()

def queue_name(queue, version):
    return '%s~%s' % (queue, version)

def make_task_file(path):
    with open(path) as f:
        data = json.loads(f.read())
    return make_task_conf(data)

def make_task_conf(conf):
    class task(object):
        def __init__(self, queue):
            self._queue = queue
            self.queue = queue_name(queue, conf.get('version',''))
            self.conf = conf
        
        def __call__(self, fun):
            @wraps(fun)
            def delay(*args, **kwargs):
                if 'paxd_timeout' in kwargs:
                    paxd_timeout = kwargs['paxd_timeout']
                    del kwargs['paxd_timeout']
                else:
                    paxd_timeout = None
                return PRequest(redis, self.queue, args=args, kwds=kwargs, timeout=paxd_timeout).send()
            fun.delay = delay
            fun.paxd_task = True
            fun.paxd_queue = self.queue
            return fun
    return task