## PlexAPI ##
Python bindings for the Plex API.

* Navigate your Plex library.
* Mark shows watched or unwatched.
* Request rescan, analyze, empty trash.
* Play media on connected clients.

Planned features:

* Create and maintain playlists.
* Use API from another network.
* Navigate shared libraries.
* List active sessions.
* Play trailers and extras.
* Provide useful utility scripts.
* Better support for Music and Photos?

#### Install ###

    pip install plexapi

#### Examples ####

    from plexapi.server import PlexServer
    server = PlexServer()

    # Example 1: List all unwatched content in library.
    for section in server.library.sections():
        print 'Unwatched content in %s:' % section.title
        for video in section.unwatched():
            print '  %s' % video.title

    # Example 2: Mark all Conan episodes watched.
    server.library.get('Conan (2010)').markWatched()

    # Example 3: List all Clients connected to the Server.
    for client in server.clients():
        print client.name

    # Example 4: Play the Movie Avatar on my iPhone.
    avatar = server.library.section('Movies').get('Avatar')
    client = server.client("Michael's iPhone")
    client.playMedia(avatar)

    # Example 5: List all content with the word 'Game' in the title.
    for video in server.search('Game'):
        print '%s (%s)' % (video.title, video.TYPE)

    # Example 6: List all movies directed by the same person as Jurassic Park.
    jurassic_park = server.library.section('Movies').get('Jurassic Park')
    director = jurassic_park.directors[0]
    for movie in director.related():
        print movie.title

    # Example 7: List files for the latest episode of Friends.
    the_last_one = server.library.get('Friends').episodes()[-1]
    for part in the_last_one.iter_parts():
        print part.file
