# -*- coding: utf-8 -*-
"""
    pocoo.filetemplates
    ~~~~~~~~~~~~~~~~~~~

    Contains templates for autogenerated files.

    :copyright: 2006 by Georg Brandl.
    :license: GNU GPL, see LICENSE for more details.
"""

#
# All templates are %-substituted with a dictionary containing:
#  'path': the new instance's absolute path
#  'executable': interpreter file name
#

# TODO: need a way to generate a default config.
#: Default config file ``pocoo.conf`` for new instances.
DEFAULT_CONFIG = '''\
# -*- coding: utf-8 -*-

section general:
    # servername + port + path to script (don't forget the trailing slash)
    serverpath = http://localhost:8080/

    # the application's charset
    charset = utf-8

    # list of all non-core packages to load
    packages = list:
        pony
        highlight

    # enabled auth module
    auth_module = SessionAuth

    # true if the system should inform the admins about errors
    send_error_mails = false

    # list of administrator email addresses
    admin_mails = list:
        me@example.invalid
        you@example.invalid


section database:
    # the database URI, see http://sqlobject.org/SQLObject.html#declaring-the-class
    # TODO: Provide examples in the docs
    uri = sqlite:////tmp/test.db
    #uri = postgres://pocoo@localhost/pocoo
    #uri = mysql://root@localhost/pocoo

    # print database queries (only if in debug mode)
    verbose = false


section development:
    # enable debug mode?
    # TODO: disable this on release
    debug = true

    # enable colubrid's evalexception feature? (only when in debug mode)
    # WARNING: DON'T ENABLE THIS ON A PUBLIC SERVER, IT ALLOWS CLIENTS
    #          TO EXECUTE ARBITRARY CODE WHEN AN EXCEPTION IS ENCOUNTERED!
    enable_evalexception = false

    # send log output to: none|stdout|stderr|filename (XXX currently not working)
    log_output = stderr

    # development server hostname
    hostname = localhost

    # development server port
    port = 8080


# caching configuration
section cache:
    # use memcache? only useful for FastCGI and other persistent interface types.
    enabled = true

    # cache parsed templates in the memory
    template_memcache = false

    # cache parsed template nodelists on the disk
    template_diskcache = false


section security:
    # password_strength:
    #   0    non empty passwords
    #   1    at least 4 chars
    #   2    at least 6 chars
    #   3    at least 6 chars, letters and numbers
    #   4    at least 6 chars, letters, numbers and special chars
    password_strength = 3

    # activation_level:
    #   0    automatically activate the user after registration
    #   1    the user has to activate the account via mail
    #   2    an administrator has to activate the account
    activation_level = 1

    # allow users to change their username?
    username_change = false


# SMTP configuration for mail notifications
section email:
    # mail server configuration
    host = localhost
    user =
    pass =

    # the mail address of the system mails
    from = My Pocoo Forum <noreply@localhost>

    # subject prefix '[pocoo] ' for example
    prefix =

    # subject suffix
    suffix =

    # mail signature
    signature = Your board admin team


section board:
    # The title of the pocoo board
    title = Pocoo
    # A short description of this board
    description = ...comes with ponies included
    # A logo image (must be an absolute URL)
    logo =

    # Text for a link displayed in the top right corner,
    # leave blank to disable
    toplinktitle =
    # Target for the top link
    toplinktarget = /

    # After how many seconds should the confirm message after an action
    # redirect to the next page
    redirecttime = 3
    # Are the users allowed to automatically be logged in
    autologin = True
    # Which image should be used as favicon?
    favicon = favicon.ico
    # The time after that cookies will get deleted (in seconds)
    cookieexpire = 7200
    # Session cookie name
    cookiename = pocoo_sid
    # Do new user accounts require email address verification?
    email_verification = false
    # Default View
    # the default view if the user hasn't defined on in the settings:
    #   flat            phpbb like bulletin board
    #   threaded        mailinglist like threaded view
    default_view = threaded
    # number of posts / page for flat view
    posts_per_page = 15
    # number of threads on the forum view
    threads_per_page = 20

    # are avatars allowed?
    allow_avatars = true
    # maximal avatar size in pixel
    avatar_dimension = 80

    # Parser used for converting postings to HTML
    # pocoo ships the following parsers:
    #   plain           a text-only parser that just creates links and breaks
    #                   lines; HTML is escaped.
    #   bbcode          phpbb like bbcode parser
    #   rest            restructured text parser
    #   simplehtml      passes through HTML, but removes some
    #                   unwanted tags (like <script>)
    syntax_parser = bbcode

    # bbcode tags allowed in signature.
    # set this to 'ALL' to enable all tags
    # seperate the list of allowed tags with a comma
    bbcode_signature_tags = b, i, u, s, size, url, color, email, code

    # the maximum length allowed for the signature
    signature_length = 255

    # the maximum number of lines for the signature
    signature_lines = 3

    # Smiley providers to replace smilies in forum text.
    # "default" is the pocoo standard parser.
    smiley_providers = list:
        default


section messages:
    # Terms of Use for Login and Registering
    termsofuse =
    # A notice that is shown when creating a new post
    newpostnotice =
'''

#: ``manage.py`` for new instances.
MANAGEPY = '''#!%(executable)s
# -*- coding: utf-8 -*-
"""
    Pocoo management wrapper for this instance
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    This file was generated automagically - you should not need
    to edit it.

    :copyright: 2006 by the Pocoo team.
    :license: GNU GPL, see LICENSE for more details.
"""

import sys, os

thisdir = os.path.dirname(__file__)
root = os.environ.get("POCOO_ROOT", None) or thisdir

pathfile = os.path.join(thisdir, 'PYTHONPATH')
if os.path.isfile(pathfile):
    sys.path.extend(p.strip() for p in open(pathfile) if p.strip())

import pocoo.management
pocoo.management.main(root=thisdir)
'''

#: ``site.pkg/__init__.py`` for new instances.
SITEINITPY = '''\
# -*- coding: utf-8 -*-
"""
    Pocoo site package
    ~~~~~~~~~~~~~~~~~~

    This is the Pocoo "site" package which is always loaded.
    Place custom components here or in subpackages.

    Don\'t forget to update the ``package.conf`` file accordingly!
"""
'''

#: ``packages/README`` for new instances.
PACKAGESREADME = '''\
Put packages containing plugins here.
'''

#: ``site.pkg/package.conf`` for new instances.
SITEPACKAGECONF = '''\
#
# Pocoo site package
# ~~~~~~~~~~~~~~~~~~
#
# For every component, table, template tag/filter and middleware
# you add to the site package, there must be an entry in this file.
#

fullname = "Pocoo site package for %(path)s"
description = "This package contains site-specific customization."
author = "Site admin"

components = list:
    # Add component names here, with module names relative to
    # the package.
    # For example, if you have a component named "UserGreeter"
    # in site.pkg/greeter.py, the entry must be

    # greeter.UserGreeter

tables = list:
    # The same for database tables (inheriting from pocoo.db.Table).

template_tags = list:
    # The same for template tags (inheriting from jinja.nodes.Node).

template_filters = list:
    # The same for template filters (functions implenting Jinja filters).

middlewares = list:
    # The same for middlewares (WSGI application wrappers).

'''

#: ``site.pkg/templates/README`` for new instances.
SITETEMPLATEREADME = '''\
Place custom templates here.
'''

#: ``site.pkg/static/README`` for new instances.
SITESTATICREADME = '''\
Put static content here.
'''

#: ``site.pkg/blobs/README`` for new instances.
BLOBSREADME = '''\
This directory is used for storing uploaded files and other binary data.
'''

#: ``site.pkg/cache/README`` for new instances.
CACHEREADME = '''\
This directory is used for caching data.
'''

#: ``site.pkg/avatars/README`` for new instances.
AVATARSREADME = '''\
This directory is used for storing user avatars.
'''
