/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.mozilla.javascript.ScriptRuntime;

class TokenMapper {
    private ArrayList functionBracePositions = new ArrayList();
    private ArrayList scopeReplacedTokens = new ArrayList();
    private int lastTokenCount = 0;

    TokenMapper() {
    }

    private String getMappedToken(String token, boolean newMapping) {
        String nt = null;
        HashMap tokens = (HashMap)this.scopeReplacedTokens.get(this.scopeReplacedTokens.size() - 1);
        if (newMapping) {
            ++this.lastTokenCount;
            nt = new String("_" + Integer.toHexString(this.lastTokenCount));
            if (nt.length() >= token.length()) {
                nt = token;
            }
            tokens.put(token, nt);
            return nt;
        }
        if (this.hasTokenMapping(token)) {
            return this.getTokenMapping(token);
        }
        return token;
    }

    private boolean hasLocalTokenMapping(String token) {
        if (this.scopeReplacedTokens.size() < 1) {
            return false;
        }
        HashMap tokens = (HashMap)this.scopeReplacedTokens.get(this.scopeReplacedTokens.size() - 1);
        return tokens.containsKey(token);
    }

    private boolean hasTokenMapping(String token) {
        String blank = new String("");
        return !blank.equals(this.getTokenMapping(token));
    }

    private String getTokenMapping(String token) {
        for (int i = this.scopeReplacedTokens.size() - 1; i >= 0; --i) {
            HashMap tokens = (HashMap)this.scopeReplacedTokens.get(i);
            if (!tokens.containsKey(token)) continue;
            return (String)tokens.get(token);
        }
        return new String("");
    }

    public int printCompressed(String source, int offset, boolean asQuotedString, StringBuffer sb, int prevToken, boolean inArgsList, int currentLevel) {
        boolean newMapping = false;
        int length = source.charAt(offset);
        ++offset;
        if ((0x8000 & length) != 0) {
            length = (Short.MAX_VALUE & length) << 16 | source.charAt(offset);
            ++offset;
        }
        if (sb != null) {
            String str = source.substring(offset, offset + length);
            String sourceStr = new String(str);
            if (prevToken == 118 && !this.hasLocalTokenMapping(sourceStr) || inArgsList) {
                newMapping = true;
            }
            if ((this.functionBracePositions.size() > 0 && currentLevel >= (Integer)this.functionBracePositions.get(this.functionBracePositions.size() - 1) || inArgsList) && prevToken != 104) {
                str = this.getMappedToken(str, newMapping);
            }
            if (!inArgsList && asQuotedString && (prevToken == 81 || prevToken == 85)) {
                str = sourceStr;
            }
            if (!asQuotedString) {
                sb.append(str);
            } else {
                sb.append('\"');
                sb.append(ScriptRuntime.escapeString(str));
                sb.append('\"');
            }
        }
        return offset + length;
    }

    public void enterNestingLevel(int braceNesting) {
        this.functionBracePositions.add(new Integer(braceNesting + 1));
        this.scopeReplacedTokens.add(new HashMap());
    }

    public void leaveNestingLevel(int braceNesting) {
        Integer bn = new Integer(braceNesting);
        if (this.functionBracePositions.contains(bn) && this.scopeReplacedTokens.size() > 0) {
            int scopedSize = this.scopeReplacedTokens.size();
            this.scopeReplacedTokens.remove(scopedSize - 1);
            ((AbstractCollection)this.functionBracePositions).remove(bn);
        }
    }
}

