#!/usr/bin/env python3

from tkinter import *
from PIL import ImageTk

class PopupTk(Frame):
    def __init__(self, master=None, title="Notification", msg="New information", duration=2):
        # Frame.__init__(self, master)
        super().__init__(master)
        self.duration = duration

        # setup text labels
        title_label = Label(self, text=title, wraplength=250, width=255)
        title_label.config(justify=LEFT, anchor="w", font=("Arial", 12, "bold"))
        title_label.pack(fill=X, expand=True)
        msg_text = Text(self, width=255, height=80, font=("sans", 11), wrap=WORD)
        msg_text.insert(INSERT, msg)
        msg_text.pack(fill=BOTH, expand=True)

        self.config(padx=10, pady=5)
        self.pack(side=TOP, fill=BOTH, expand=YES)

        # get screen width and height
        ws = self.master.winfo_screenwidth()
        hs = self.master.winfo_screenheight()
        w = 300
        h = 100
        # calculate position x, y
        x = ws - w
        y = hs - h
        self.master.geometry('%dx%d+%d+%d' % (w, h, x, y))
        self.master.overrideredirect(True)
        self.master.lift()

    def auto_close(self):
        msec_until_close = self.duration * 1000
        self.master.after(msec_until_close, self.master.destroy)

def poptk(msg, title="Notification", duration=15):
    root = Tk()
    root.config(padx=5, pady=5)
    close_label = CloseLabel(root)
    close_label.setup()
    sp = PopupTk(root, title=title, msg=msg, duration=duration)
    sp.auto_close()
    root.call('wm', 'attributes', '.', '-topmost', True)
    root.mainloop()


class CloseLabel(Label):
    def __int__(self, master):
        super().__init__(master)

    def setup(self):
        self.img_bytes = b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00(\x00\x00\x00(\x08\x06\x00\x00\x00\x8c\xfe\xb8m\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\x00\x00\tpHYs\x00\x00\r\xd7\x00\x00\r\xd7\x01B(\x9bx\x00\x00\x00\x19tEXtSoftware\x00www.inkscape.org\x9b\xee<\x1a\x00\x00\x00ItEXtCopyright\x00Public Domain http://creativecommons.org/licenses/publicdomain/Y\xc3\xfe\xca\x00\x00\x03\nIDATX\x85\xc5\x98Ok\x13A\x1c\x86\xdf\xdfdCkB\x0b\x96\xb6\xe2A\xab\x88\x95*-t\xb3\x84\xd0\xe4"XD{\xd0\x83\x17\x15O\x1e\xfb\r\xc4\xa3_\xc3\xa3\x9e<\xe8)\x07\xbdY\x8b\x84$\xf5R,zS\x10\n\x9e*\xd6l\xdc\xcc\xeb\xc1\xb4&\xd9\x7f\xc9\xfe\x89\x0f\xece\xe67\xf3>\xd9\xd9Y2+$\x11\x85\xb5\xb5\xb5\x13\xb6m_\x13\x91S\x00f{.\x00\xf8~t\x91\xdc\x9f\x98\x98x\xb3\xbd\xbd\xfd+J\x8e\x11\xc9\x0e\x80m\xdb\x97E\xe4\x81O\xf7\xd9\xee\x05\x11\x81m\xdb\xdf\x004\xa2\xe4\xa8\x88~p\x1cg\x8fd\'\xac\x8ed\xc7q\x9c\xbd\xa89\x12u\x89\x01`uu\xf5\xa2a\x18%\xadu\xb1\xbb\xd4\xbdb\xfbJ\xa9\x9a\xe38\xefwvv>\xff\x17\xc1#*\x95\xcaT\xab\xd5z\xda\xdb699\xf9pkk\xebG\xdc\xb9#/q/\x07\x07\x07\xaeg\xd9\xab-\n\xb1\xee`\xa5R\x99:<<<\xa3\x94Z\x04po\xa0\xfb\xb9\xd6\xfaS.\x97\xfb\x1a\xe7N\x8e,\xd8\x95**\xa5\xca\x00\xae\x00\x90\x90!\x04\xb0\xab\xb5~\x97\xcb\xe5j\xa3\xca\x0e-("\xca4\xcd\xdb"r\x07\xd1_O\x0e\xc9\x17\xcdf\xf3%I\x9d\x98\xa0eYY\x00\x8f\x01,E\x14\x1b\xe4#\x80\'\xf5z\xfdwX\xe1P\x9bDD\xee"99\x00X\xea\xce\x19J\xa8\xa0eY\xcb$7\xe2;\xf5Cr\xc3\xb2\xac\xe5\xb0\xba@A\x11Q$7\x11\xbe\x11\xa2 $7E$\xd0!\xb0\xb3X,.\x88\xc8L\xb2^\xff\x10\x91\x99b\xb1\xb8\x10T\x13(\xe88\xce\xa5d\x95F\xcf\x08[\xe2\xd4\x05\xc32\xc26\xc9b\x82.\x912|\x05WVVN\x02\x98K\\\xc7\xcd\\7\xcb\x13_\xc1l6\x9b\xfa\xf2\x0e\x93\xe5+8\x8e\xe7o\x98\xac \xc1\xf3\xe9\xe8\x8c\x96\xe5+H2\xf0\xfd\x94$AY\x9e\x82\xa6i\xce\x01\xc8\xa7f\xe4&\xdf\xcdt\xe1)h\x18\xc6\xb9TuF\xc8\xf4\x14\xd4Z{\x16\xa7\x89_\xa6\xa7 I\xcf\xe24\xf1\xcb\xf4\x14TJ\x8dm\x83\x84e\xba\x04K\xa5\xd24\xc9\xf9\xf4\x95\xfa!9_*\x95\xa6\x07\xdb]\x82\x9dN\xe7\xeax\x94\xdcxe\xf7\t\x8a\x88\x00X\x1f\x9b\x91\x9b\xf5\xae\xc31}\xa73\xd34+$\xf3\x00~\x02\x80\x88\x10\x00\xb4\xd6\xae\x93\xd5Q\x1f\xfe\x1e+\x83\x10\x00 \xe9\xfaW\xae\x94\xea\xeb#\x997M\xb3\x02\xe0\xed\xf1\xe0$>}\xa4\x89\x94\xcb\xe5)\xdb\xb6\x0b\x83\x1d^\xbfx\x98\x9aa\xc6\x01\x80a\x18}u^\xe3\xb2\xd9l\xc3h\xb5Z\x8f\x00\\\x18f\xd2A\x06\x1e\x17\xdf6/\xb4\x0e?\xb7\xb7\xdb\xed\xeb\n\xc0\xe9Q\xc5\xc6\xc8\xacA\xf2\xb5\x88\xdc\x8c2ZD2$\xc3\x8e\r\x0e\x80v\x94\xf9IVcm\x92B\xa1p_Dn\x85\x84\xbcj4\x1a\xcf\xa2f\xc4\xfa>\x98\xc9d>$Q\x13D,\xc1Z\xad\xb6K\xb2\xea\xd7O\xb2Z\xab\xd5v\xe3d$\xf2\x1e4M\xd3RJ\xdd@\xf7\xcb>\x80/Z\xebj\xb3\xd9\xac\xc7\x9d\xfb\x0f\x18\x8c-O\x8e\xe7)\x89\x00\x00\x00\x00IEND\xaeB`\x82'
        self.img = ImageTk.PhotoImage(data=self.img_bytes)
        self.config(image=self.img)
        self.bind("<Button-1>", lambda e: self.master.quit())
        self.pack(side=LEFT)



if __name__ == '__main__':
    poptk("Hi there! How are you doing? I can't wait to see you again! I am doing something super interesting! Hope you will join me soon!")


