#!/usr/bin/python
import time 
import string
from threading import Thread
import time
import numpy as np
import sys
import Queue
import random
import os
import datetime
import cPickle
import copy
import array
import socket
import commands

class CheckEye(Thread):
  ''' This Thread check where is eye position and keep in a variable if record is pressed and save into a pickle (dump) file if save is pressed on the GUI 
  The data are saved with TTL pulse and time and other information useful for analyses. 
  '''
  def __init__(self,idata,Quitb,Maindict):
    Thread.__init__(self)
    self.idata = idata
    self.Quitb = Quitb
    self.maxruneyesamples = 500000
    self.nbcol = 8
    self.run_eye = np.zeros((self.maxruneyesamples,self.nbcol ))
    self.Maindict = Maindict
    self.tmp = array.array('H')
    self.indrec = 0
  def run(self):
    Xe=0
    Ye=0
    Xo=0
    Yo=0
    t0=time.time()
    while (self.Quitb.empty()):
      if not self.idata.empty():
	  if not(self.Maindict['record_eye']) and self.Maindict['MRTTLpulsecounter']>1: # To adapt if you wish to record eye at another time ; Olivier
	    self.Maindict['record_eye']=True
	    t0=time.time()
	  [Xe,Ye,Dia] = self.idata.get()
	  #[Xo,Yo] = [Xe,Ye]  
	  [Xe,Ye] = [self.Maindict['Scale XY'][0]*((-Xe)-self.Maindict['Offset XY'][0]), self.Maindict['Scale XY'][1]*((-Ye)-self.Maindict['Offset XY'][1])]
	  self.Maindict['fixpoint']['pts'] = [int(Xe),int(Ye)]
	  #print self.fixpoint['pts']
	  if self.Maindict['record_eye']:
	    if self.indrec<len(self.run_eye):
	      #self.run_eye[self.indrec,:]=[time.time(),Xo,Yo,0]
	      self.run_eye[self.indrec,:]=[time.time()-t0,Xe,Ye,Dia,self.Maindict['touchbarstatus'],self.Maindict['TotalRWD'],self.Maindict['targetindex'],self.Maindict['MRTTLpulsecounter']]
	      self.indrec +=1
	    else:
	      self.indrec=0 
	      self.run_eye = np.zeros((self.maxruneyesamples,self.nbcol ))
	  if self.Maindict['save_eye']:
	    a=datetime.datetime.now()
	    namefile='eye_%d_%02d_%02d_%02d_%02d.pkl' % (a.year,a.month, a.day, a.hour, a.minute)
	    path_eyedata='/home/'+os.getlogin()+'/Desktop/data_behaviour/'
	    fullpath_eyedata=path_eyedata+namefile
	    if not(os.path.exists(path_eyedata)):
	      os.mkdir(path_eyedata)
	    print  'Create Eye data file: %s' % fullpath_eyedata
	    self.eyefile = open(fullpath_eyedata, 'wb')
	    self.Maindict['save_eye'] = False
	    print 'Saving eye data : %s' % fullpath_eyedata
	    cPickle.dump(self.run_eye[np.where(self.run_eye[:,0]!=0),:], self.eyefile , -1)
	    self.eyefile.close() 
	  if self.Maindict['clear_eye']:
	    self.Maindict['clear_eye'] = False
	    self.run_eye = np.zeros((self.maxruneyesamples,self.nbcol ))
	    self.indrec = 0
	  #self.tmp = np.zeros(len(self.Maindict['ListofWindows'])) 
	  difwin= len(self.Maindict['ListofWindows']) - len(self.tmp) # Nb of extra windows without an index of fix yet
	  if difwin>0:
	    for x in range(0,difwin):
	      self.tmp.append(0)
	  elif difwin<0:
	    for x in range(0,difwin):
	      self.tmp.pop()
	  for win in self.Maindict['ListofWindows']:
	    [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]] = win.default['vertices']
	    #print 'Hello'
	    if (Xe>xmax) or (Xe<xmin) or (Ye<ymin) or  (Ye>ymax):
	      #if outside the window set color to RED
	      win.default['lineColor']=[1,-1, -1]
	      if not(win.ptIN):
		#print self.Maindict
		if (time.time()-win.time)>self.Maindict['SaccadeDelay']/1000. and self.tmp[win.ID]==1: # now we can really consider the eye OUT
		  #self.Maindict['indexWin'].remove(win.ID)
		  self.tmp[win.ID]=0
		  #print self.Maindict
	      else:
		win.update(False)
	      
	      #f0=1
	    elif not(win.ptIN):
	      #print 'Get in'
	      self.tmp[win.ID]=1
	      win.default['lineColor']=[1,1, -1]# if inside the fixation window : set to green or yellow color
	      win.update(True)
	      #self.Maindict['indexWin'].append(win.ID)
	  if self.tmp != self.Maindict['indexWin'] :
	    self.Maindict['indexWin'] = copy.deepcopy(self.tmp)    
	  

    print "Quit Check Eye"
  
