import serial
import string
from threading import Thread
import Queue
import binascii
import time
import datetime
import time
import numpy as np
import os

ser = serial.Serial()
eyedata = Queue.Queue()
disconnect = Queue.Queue()

class read_ISCAN(Thread):
  '''
  This is a Read_ISCAN Python Class : it is very useful to interface with ISCAN EyeTracker
  Please set the serial connection to COM1, 56K.
  You can use this code to get a recording of other parameters available through the serial streaming of data.
  Olivier Joly, Oxford, Last Updated 4th Oct. 2013.
  Email : olivier . j . joly at gmail.com
  '''
  def __init__(self,ser,eyedata,disconnect):
      Thread.__init__(self)
      self.ser = ser
      self.eyedata = eyedata
      self.ser.baudrate = 57600 # 56k on the ISCAN Eyetracker, you may try higher values...
      USB_path = '/dev/ttyUSB0' # If you are using the USB/rs232 connection
      if os.path.exists(USB_path):
	self.ser.port = '/dev/ttyUSB0'
	print 'It seems you are using USB connection'
      else :
	print 'It seems you are using DB9 connection'
	self.ser.port = 0#'COM1' # If you are using a simple DB9 female/ DB9 female cable
      self.ser.setParity('N')
      self.disconnect = disconnect
      self.ser.open()
      if self.ser.isOpen():
	print "Serial port is open"
	self.runable =  True
      else:
	print "Failed open serial port"
	self.runable = False
      
  def run(self):
    t0 = time.time()
    if self.runable:
      while (self.disconnect.empty()):
	if self.ser.isOpen() :
	  if binascii.b2a_hex(self.ser.read(1))=='44':
	    if binascii.b2a_hex(self.ser.read(1))=='44':
	      intX = ord(self.ser.read(1))+ ord(self.ser.read(1))*256
	      intY = ord(self.ser.read(1))+ ord(self.ser.read(1))*256
	      Dia = ord(self.ser.read(1))+ ord(self.ser.read(1))*256
	      try:
		#listdata = [np.float(x) for x in line.strip().split('\t')]
		if self.eyedata.empty():
		  t0 = time.time()
		  self.eyedata.put([intX/10.,intY/10.,Dia])
	      except :
		print 'problem with ISCAN'
      if self.ser.isOpen() :
	    self.ser.close()
	    print "Closing serial port"
      print "Quit Iscan Connection"
