import socket
#import serial
#import string
from threading import Thread
import Queue
#import binascii
import time
#import datetime
#import time
'''
The following code is useful to set an Ethernet connection between a python client (your PC) and the server (iView SensoMotoric instruments PC)
This way you are able to get the eye data in real-time. 
Last Update 23 August 2012
Olivier Joly, IoN, Newcastle upon Tyne, UK
Email : olivier . j . joly at gmail [dot] com
'''

# General defintions 



eyedata = Queue.Queue()
disconnect = Queue.Queue()

class read_iView(Thread):
  '''
  This is a Read_viewPoint Python Class : it is very useful to interface with Arrington EyeTracker
  Please set the serial connection to COM1, 56K and untick XonXoff on the Eyetracker PC or adapt the following code accordingly.
  You can use this code to get a recording of other parameters available through the serial streaming of data.
  Olivier Joly, IoN, Newcastle upon Tyne, Last Updated 23 August 2012.
  Email : olivier . j . joly at gmail [dot] com
  '''
  def __init__(self,eyedata,disconnect):
      Thread.__init__(self)
      localIP = '10.10.10.1' # Behaviour/Stim PC
      localport = 4444
      IP_iView = '10.10.10.2' # set this IP for iView PC
      port_iView = 5555
      self.eyedata = eyedata
      self.localIP = localIP
      self.localport = localport
      self.IP_iView = IP_iView
      self.port_iView = port_iView
      #self.ser.baudrate = 57600 # 56k on the viewpoint Eyetracker, you may try higher values...
      #self.ser.port = '/dev/ttyUSB0'
      #self.ser.setParity('N')
      #self.ser.setXonXoff(1)
      #self.ser.setTimeout(3)
      self.disconnect = disconnect
      self.sock = socket.socket( socket.AF_INET, socket.SOCK_DGRAM ) # Create a socket
      self.buf = 4096 # Size of the buffer
      self.sock.bind((self.localIP,self.localport)) # Bind localIP
      message = 'Start of Experiment'
      entire_message = message+"\n\r\n"
      self.sock.sendto( entire_message, (self.IP_iView, self.port_iView) )
      self.sock.setblocking(1)
      #try : self.ser.open()
      #except :  print "Failed open serial port"
      #if self.ser.isOpen():
	  #print "serial port open"
      #else:
	  #print "Failed open serial port"
  def run(self):
    t0 = time.time()
    while (self.disconnect.empty()):
      data = self.sock.recv(self.buf)
      #print time.time()-t0
      if self.eyedata.empty():
	datastrings = data.split()
	#print 'Refresh Rate : %fHz' % (1./(time.time()-t0))
	#print 'time: %f, X: %f, Y: %f,  delta: %d ms, pupil_x: %d, pupil_y: %d, ct: %d minute, index: %d' % (time.time() - t0, x,y,delta,pupil_x,pupil_y,ct,index)
	t0=time.time()
	self.eyedata.put([float(datastrings[2]),float(datastrings[3])])
    message = "ET_FRM %TS: %GX,%GY"
    closing_message = message+"\n\r\n"
    sock.sendto( entire_message, (self.IP_iView, self.port_iView) )
    print "Quit iView Connection"




