import serial
import string
from threading import Thread
import Queue
import binascii
import time
import datetime
import time

ser = serial.Serial()
eyedata = Queue.Queue()
disconnect = Queue.Queue()

class readVP(Thread):
  '''
  This is a Read_viewPoint Python Class : it is very useful to interface with Arrington EyeTracker
  Please set the serial connection to COM1, 56K and untick XonXoff on the Eyetracker PC or adapt the following code accordingly.
  You can use this code to get a recording of other parameters available through the serial streaming of data.
  Olivier Joly, IoN, Newcastle upon Tyne, Last Updated 23 August 2012.
  Email : olivier . j . joly at gmail [dot] com
  '''
  def __init__(self,ser,eyedata,disconnect):
      Thread.__init__(self)
      self.ser = ser
      self.eyedata = eyedata
      self.ser.baudrate = 57600 # 56k on the viewpoint Eyetracker, you may try higher values...
      self.ser.port = '/dev/ttyUSB0'
      self.ser.setParity('N')
      #self.ser.setXonXoff(1)
      #self.ser.setTimeout(3)
      self.disconnect = disconnect
      try : self.ser.open()
      except :  print "Failed open serial port"
      if self.ser.isOpen():
	  print "serial port open"
      else:
	  print "Failed open serial port"
  def run(self):
    t0= time.time()
    while (self.disconnect.empty()):
      if self.ser.isOpen() :
	V = self.ser.read(1)
	if V=='V':
	  P = self.ser.read(1)
	  if P=='P':
	    code = self.ser.read(1)
	    if int(binascii.b2a_hex(code),16) == 10: # if True : it seems we get eye data !!!
	      nb_bytes = self.ser.read(1)
	      codenbbytes = int(binascii.b2a_hex(nb_bytes),16)
	      if codenbbytes == 16: # if True : Header as expected
		X = self.ser.read(2)
		x = (int(binascii.b2a_hex(X),16)-5000)/100. # better to rescale to fit a screen info
		Y = self.ser.read(2)
		y = (int(binascii.b2a_hex(Y),16)-5000)/100.
		delta = self.ser.read(2)
		delta = int(binascii.b2a_hex(delta),16)
		boxcode = self.ser.read(2)
		pupil_x = self.ser.read(2)
		pupil_x = int(binascii.b2a_hex(pupil_x),16)
		pupil_y = self.ser.read(2)
		pupil_y = int(binascii.b2a_hex(pupil_y),16)
		ct = self.ser.read(2)
		ct = int(binascii.b2a_hex(ct),16)
		ik = self.ser.read(2)
		index = int(binascii.b2a_hex(ik),16)
		#print time.time()-t0
		if self.eyedata.empty():
		  #print 'time: %f, X: %f, Y: %f,  delta: %d ms, pupil_x: %d, pupil_y: %d, ct: %d minute, index: %d' % (time.time() - t0, x,y,delta,pupil_x,pupil_y,ct,index)
		  #t0=time.time()
		  self.eyedata.put([x,y])
    if self.ser.isOpen() :
	  self.ser.close()
	  print "Closing serial port"
    print "Quit VP Connection"












