from psychopy import visual,  event, core
import random
import os
from threading import Thread
import time
import Queue
import string
from . import fix_windows as fw
import copy
import datetime
import pygame
import socket
import cPickle
if socket.gethostname()=='EP':
  print 'EP is 64 bit'
  from pyglet.gl import *

class ClientReward(Thread):
  def __init__(self,Rewarddict,Quitb):
    Thread.__init__(self)
    PORT = 6008
    IP = "localhost"
    self.buffsize = 512
    self.client_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    self.client_socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    self.client_socket.connect((IP, PORT)) # Connect to behaviour Computer change localhost to the IP adress 
    self.Rewarddict = Rewarddict
    self.localdict = {'RewardValue':10, 'RewardItems':5}
    self.Quitb = Quitb

  def run(self):
    while self.Quitb.empty():
	if not(self.Rewarddict['Queue'].empty()):
	  self.Rewarddict['Queue'].get()
	  #self.Rewarddict['RewardValue'] !=self.localdict['RewardValue']:
	  self.localdict['RewardValue'] = self.Rewarddict['RewardValue']
	  self.localdict['RewardItems'] = self.Rewarddict['RewardItems']
	  txt = '%d' % self.localdict['RewardValue']
	  self.client_socket.send(cPickle.dumps(self.localdict))
	  tmp = self.client_socket.recv(self.buffsize)
	  print 'ClientReward sending reward from Manual Juice : %d ' % self.Rewarddict['RewardValue']
	  print tmp
    self.localdict['QuitTCP']=True
    self.client_socket.send(cPickle.dumps(self.localdict))
    time.sleep(2)
    print 'Quit TCP client'
    self.client_socket.close()



class ISCANWIN(Thread):
  def __init__(self,Quitb,Maindict,TouchBar,MR_TTL_pulse):
    Thread.__init__(self)
    self.Quitb = Quitb
    self.mainloop=True
    self.Maindict = Maindict
    self.TouchBar = TouchBar
    self.MR_TTL_pulse = MR_TTL_pulse
  
  def run(self):
    '''
    '''
    Rewarddict = {
      'RewardValue':10,
      'RewardItems':3,
      'Queue':Queue.Queue()
      }
    #Reward = ClientReward(Rewarddict,self.Quitb)
    #Reward.start()
    #print 'Start a local TCP client for Manual Reward'
    # ----------------------
    self.w = 600
    self.h = 600
    win1 = visual.Window((self.w, self.h), allowGUI=True,  bitsMode=None,  units='pix', winType='pyglet', screen=0, fullscr=False, pos=(+300, +300),color=(-0.5, -0.5, -0.5))
    #refreshfreq = 60.0
    #win1._refreshThreshold=1/refreshfreq+0.004 # 59.98 Hz ??
    pp = os.getcwd()
    print pp
    self.degreescreen = 40
    self.pixperdeg = int(self.w/self.degreescreen)
    dx = 2        
    scmouse=2
    fixpoint = visual.PatchStim(win=win1,  units='pix', size=4, pos=[0, 0], sf=0, color=(1, 1, 1),colorSpace='rgb')
    targetpoint = visual.PatchStim(win=win1,  units='pix', size=6, pos=[0, 0], sf=0, color=(1, -1, -1),colorSpace='rgb')
    touchbarstatus = visual.PatchStim(win=win1,  units='pix', size=6, pos=[100-(self.w/2),15-(self.h/2)], sf=0, color=(1, -1, -1),colorSpace='rgb')
    mrttlpulsestatus = visual.PatchStim(win=win1,  units='pix', mask='circle',size=8, pos=[150-(self.w/2),15-(self.h/2)], sf=0, color=(1, -1, -1),colorSpace='rgb')
    allfixwin=[]
    allfixwinID=[]
    RecordEyeStatus = visual.PatchStim(win=win1,  units='pix', size=8, mask='circle', pos=[50-(self.w/2),15-(self.h/2)], sf=0, color=(1, 1, 1),colorSpace='rgb')
    for w in self.Maindict['ListofWindows']:
      s = visual.ShapeStim(win=win1, units='pix', lineColor=[1, 1, 1],lineColorSpace='rgb', lineWidth=1.0, vertices= w.default['vertices'], closeShape=True, pos=[0, 0], ori=0.0, opacity=1.0, depth=0.0, interpolate=False)
      s.setFillColor(None, colorSpace='rgb', operation='')
      [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]] = w.default['vertices']
      t = visual.TextStim(win=win1, pos=[xmin,ymax], text = '%d' % (w.ID+1), height=15)
      allfixwinID.append(t) 
      allfixwin.append(s)
    #pygame.display.get_init()  
    #import pygame.event as evt
    myMouse = event.Mouse(win = win1)
    positionXYtext = visual.TextStim(win = win1, pos=[100-(self.w/2),30-(self.h/2)],text='Xi=000.0 Yi=000.0', height=15)
    positionXYstext = visual.TextStim(win = win1, pos=[100-(self.w/2),15-(self.h/2)],text='Xs=000.0 Ys=000.0', height=15)
    #WinSizetext = visual.TextStim(win = win1, pos=[0,15-(self.h/2)],text='Fix Win: ?x? deg', height=15)
    tstamp=0
    indpos=0
    clock = core.Clock()
    t0 = clock.getTime()
    firstpass = True
    duration_XP = str(datetime.timedelta(seconds=clock.getTime()-t0)).split('.')[0]
    duration_text = visual.TextStim(win = win1, pos=[250-(self.w/2),30-(self.h/2)],text=duration_XP, height=15)
    totalduration_sec = 0
    #duration_breaks = 0
    totalduration_sec_ON = 0
    while self.mainloop:
      if firstpass :
	t0 = clock.getTime()
      #if not(self.Maindict['run_break_status']):
	#win1.setColor((0,0,0))
	#t_zero = clock.getTime()
      #if self.Maindict['run_break_status']:
	#win1.setColor((-1,-1,-1))
	##t_zero = clock.getTime()
	#totalduration_sec_ON += clock.getTime()-t_zero
      if self.Maindict['ON'] and firstpass:
	firstpass = False
	t0 = clock.getTime()
      if not(self.Maindict['ON']) and not(firstpass):
	firstpass = True
	totalduration_sec=clock.getTime()-t0
	t0 = clock.getTime()
      #if self.Maindict['ON'] and self.Maindict['ON']:
	
      if self.MR_TTL_pulse.status==1:
	mrttlpulsestatus.setColor((1, -1, -1), colorSpace='rgb', operation='')
      else :
	touchbarstatus.setColor((-1, 1, -1), colorSpace='rgb', operation='')
      if self.TouchBar.status==1:
	mrttlpulsestatus.setColor((1, -1, -1), colorSpace='rgb', operation='')
      else:
	touchbarstatus.setColor((-1, 1, -1), colorSpace='rgb', operation='')
      if self.Maindict['record_eye']:
	RecordEyeStatus.setColor((1, -1, -1), colorSpace='rgb', operation='')
      else:
       RecordEyeStatus.setColor((1, 1, 1), colorSpace='rgb', operation='')
      fixpoint.setPos(self.Maindict['fixpoint']['pts']) # in any case set fixation point
      #fixpoint.setPos((betaX*Xe, betaY*Ye)) # in any case set fixation point
      #XYtxt='Xpix=%04d Ypix=%04d' % (float(Xe),  float(Ye))
      #positionXYstext.setText(XYtxt)
      XY_input='Xi=%03d Yi=%03d TTL=%03d' % (self.Maindict['fixpoint']['pts'][0],self.Maindict['fixpoint']['pts'][1],self.Maindict['MRTTLpulsecounter'])
      duration_XP = str(datetime.timedelta(seconds=totalduration_sec+clock.getTime()-t0)).split('.')[0]
      duration_text.setText(duration_XP)
      positionXYtext.setText(XY_input)
      toomanywin = len(allfixwin)-len(self.Maindict['ListofWindows'])
      if toomanywin>0:
	for n in range(0,toomanywin):
	  allfixwin.pop()
	  allfixwinID.pop()
      i=0
      for w in self.Maindict['ListofWindows']:
	[[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]] = w.default['vertices']
	if i==len(allfixwin):
	  s=visual.ShapeStim(win=win1, units='pix', lineColor=[1, 1, 1],lineColorSpace='rgb', lineWidth=1.0, vertices= w.default['vertices'], closeShape=True, pos=[0, 0], ori=0.0, opacity=1.0, depth=0.0, interpolate=False)
	  s.setFillColor(None, colorSpace='rgb', operation='')
	  t = visual.TextStim(win=win1, pos=[xmin,ymax],text= '%d' % (w.ID+1), height=15)
	  allfixwin.append(s)
	  allfixwinID.append(t)
	
	allfixwin[i].setVertices(w.default['vertices']) # set the vertices of the fixation window
	allfixwin[i].setLineColor(w.default['lineColor']) # set the color of the fixation window
	allfixwin[i].draw()
	allfixwinID[i].setPos([xmin,ymax])
	allfixwinID[i].draw()
	i+=1
      
      RecordEyeStatus.draw()
      touchbarstatus.draw()
      mrttlpulsestatus.draw()
      targetpoint.draw()
      fixpoint.draw() # draw the fixation point
      #for fxwin in allfixwin:
	#fxwin.draw() # draw the fixation window
      #for ID in allfixwinID:
	#ID.draw()
      positionXYtext.draw()
      duration_text.draw()
      #positionXYstext.draw()
      #WinSizetext.draw()
      win1.flip() # refresh the window
      mouse1, mouse2, mouse3 = myMouse.getPressed()
      mouse_DX,mouse_DY = myMouse.getRel()
      for key in event.getKeys():
	#print key
	if key in ['left']:
	  xm,ym = myMouse.getPos()
	  mouse_dX=scmouse*mouse_DX
	  mouse_dY=scmouse*mouse_DY
	  for w in self.Maindict['ListofWindows']:
	    [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]] = w.default['vertices']
	    if (xm<xmax) & (xm>xmin) & (ym>ymin) &  (ym<ymax):
	      w.resize('X-',dx)
	if key in ['right']:
	  xm,ym = myMouse.getPos()
	  mouse_dX=scmouse*mouse_DX
	  mouse_dY=scmouse*mouse_DY
	  for w in self.Maindict['ListofWindows']:
	    [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]] = w.default['vertices']
	    if (xm<=xmax) & (xm>=xmin) & (ym>=ymin) &  (ym<=ymax):
	      w.resize('X+',dx)
	if key in ['up']:
	  xm,ym = myMouse.getPos()
	  mouse_dX=scmouse*mouse_DX
	  mouse_dY=scmouse*mouse_DY
	  for w in self.Maindict['ListofWindows']:
	    [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]] = w.default['vertices']
	    if (xm<=xmax) & (xm>=xmin) & (ym>=ymin) &  (ym<=ymax):
	      w.resize('Y+',dx)
	if key in ['down']:
	  xm,ym = myMouse.getPos()
	  mouse_dX=scmouse*mouse_DX
	  mouse_dY=scmouse*mouse_DY
	  for w in self.Maindict['ListofWindows']:
	    [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]] = w.default['vertices']
	    if (xm<xmax) & (xm>xmin) & (ym>ymin) &  (ym<ymax):
	      w.resize('Y-',dx)
	  
	#WINtxt='Fix Win= %.2f x %.2f deg' % (numpy.float(xmax-xmin)/self.pixperdeg,numpy.float(ymax-ymin)/self.pixperdeg)
	#WinSizetext.setText(WINtxt)
	if key in ['space']:
	  defPos = copy.deepcopy(fw.defaultWinPos)
	  indpos+=1
	  if indpos>len(defPos)-1:
	    indpos=0
	  targetpoint.setPos([defPos[indpos,0],defPos[indpos,1]])
	  self.Maindict['targetpos'] = [defPos[indpos,0],defPos[indpos,1]]
	  self.Maindict['targetindex'] = indpos
	#if key in ['p']:
	  #fixwin.setPos(p0)
	elif key in ['c']:
	    nbofabort=0
	    valdurrew=0
	elif key in ['escape', 'q']:
	    self.mainloop = False
  #            event.clearEvents()
	elif key in ['l']:
	  self.Maindict['MRTTLpulsestatus']=0
	elif key in ['h']:
	  self.Maindict['MRTTLpulsestatus']=1
	elif key in ['r']:
	  self.Maindict['MRTTLpulsecounter']=0
	elif key in ['i']:
	  self.Maindict['MRTTLpulsecounter']+=1
	elif key in ['j']:
	  #Rewarddict['RewardValue'] = self.Maindict['RewardManual'] #+ random.randint(-10, 10)*self.Maindict['RWD_trial']/100.
	  #Rewarddict['Queue'].put('yes')
	  print 'Juice not working'
	  #print 'increase ?'
	  #print self.Maindict['MRTTLpulsecounter']


      
      if (mouse1):
	  xm,ym = myMouse.getPos()
	  mouse_dX=scmouse*mouse_DX
	  mouse_dY=scmouse*mouse_DY
	  for w in self.Maindict['ListofWindows']:
	    [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]] = w.default['vertices']
	    if (xm<xmax) & (xm>xmin) & (ym>ymin) &  (ym<ymax):
	      w.move([mouse_dX, mouse_dY])
	    ##fixwin.setPos, '+')

      if (mouse3):
	  xm,ym = myMouse.getPos()
	  [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]] = self.Maindict['ListofWindows'][0].default['vertices']
	  #if (xm<xmax) & (xm>xmin) & (ym>ymin) &  (ym<ymax):
	    #fixwin.setPos(p0)

    self.Quitb.put(True)
    time.sleep(1)
    print  "Quit Behaviour/Tracking Win" 
    win1.close()
    core.quit()
