'''
This is about defining fixation windows
'''
import numpy as np
import time

# For 9 windows :
#defaultWinPos = 8*np.matrix([[0,0],[-10,10],[10,10],[10,-10],[-10,-10],[-10,0],[0,10],[10,0],[0,-10]])
Xamp=16
Yamp=16
# For 5 windows:
defaultWinPos = 8*np.matrix([[0,0],[-Xamp,Yamp],[Xamp,Yamp],[Xamp,-Yamp],[-Xamp,-Yamp]])
#defaultWinPos = 8*np.matrix([[0,0],[-10,10],[10,10],[10,-10],[-10,-10]])
#__init__
class FixWindow:
  def __init__(self,ID,defaultWinPos):
    self.default = dict()
    self.default['defaultWinPos'] = defaultWinPos
    self.default['win'] = 'win1'
    self.default['units'] = 'pix'
    self.default['lineColor'] = [1, 1, 1]
    self.default['lineColorSpace'] = 'rgb'
    self.default['lineWidth'] = 1.0
    width = 20
    Pts = [[defaultWinPos[ID,0]- width,defaultWinPos[ID,1]+ width],[defaultWinPos[ID,0]+ width,defaultWinPos[ID,1]+ width],[defaultWinPos[ID,0]+ width,defaultWinPos[ID,1]- width],[defaultWinPos[ID,0]- width,defaultWinPos[ID,1]-width]]
    self.default['vertices'] = Pts
    self.default['closeShape'] = True
    self.default['pos'] = [0, 0]
    self.default['ori'] = 0.0
    self.default['opacity'] = 1.0
    self.default['depth'] = 0.0
    self.default['interpolate'] = False
    self.default['setFillColor']= None
    self.ID = ID
    self.active = True
    self.ptIN = False
    self.time = time.time()
  def resize(self,action,dsize):
    '''
    Ex: aa.resize('Y-',4)
    '''
    [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]] = self.default['vertices']
    if action in ['X-']:
      xmin = xmin+dsize
      xmax = xmax-dsize
    elif action in ['X+']:
      xmin=xmin-dsize
      xmax=xmax+dsize
    elif action in ['Y+']:
      ymin = ymin-dsize
      ymax = ymax+dsize
    elif action in ['Y-']:
      ymin = ymin+dsize
      ymax = ymax-dsize
    xmin, xmax = np.sort([xmin, xmax])
    ymin, ymax = np.sort([ymin, ymax])  
    Pts = [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]]
    self.default['vertices'] = Pts
  def move(self,mouse_dmove):
    '''
    Ex: aa.move(np.asarray([2,2]))
    '''
    [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]] = self.default['vertices']
    xmin, xmax = [xmin, xmax] + mouse_dmove[0]
    ymin, ymax = [ymin, ymax] + mouse_dmove[1]
    Pts = [[xmin,ymax],[xmax,ymax],[xmax,ymin],[xmin,ymin]]
    self.default['vertices'] = Pts
    #self.default['pos'] = self.default['pos']+[mouse_dmove[0], mouse_dmove[1]]
  def update(self,ptIN):
    '''
    Changes the color and the ptIn according to status of fixation To be implemented
    '''
    self.active = not(self.active)
    self.ptIN = ptIN
    self.time = time.time()