#!/usr/bin/python
import time 
import string
from threading import Thread
import time
import numpy as np
import sys
import Queue
import random
import os
import datetime
import cPickle
import copy
import array
import socket
import commands

class bcolors:
  HEADER = '\033[95m'
  OKBLUE = '\033[94m'
  OKGREEN = '\033[92m'
  WARNING = '\033[93m'
  FAIL = '\033[91m'
  ENDC = '\033[0m'
  def disable(self):
    self.HEADER = ''
    self.OKBLUE = ''
    self.OKGREEN = ''
    self.WARNING = ''
    self.FAIL = ''
    self.ENDC = ''
class TouchBar:
  ''' A class that count status change and update the status of the touch bar/sensor. 
  '''
  def __init__(self,ID):
    self.status = 1
    self.counter = 0
    self.ID = ID
  def resetcounter(self):
    self.counter = time.time()
  def setstatus(self,status):
    self.status = status
    self.resetcounter()

class MR_TTL_pulse:
  ''' A class that counts the number of MR TTL pulse for synchronisation with stimulation and log files for fMRI analyses.
  '''
  def __init__(self,ID):
    self.status = 1
    self.counter = 0
    self.ID = ID
  def resetcounter(self):
    self.counter = 0
  def incrementcounter(self):
    self.counter +=1
  def setstatus(self,status):
    self.status = status
    #if status==0:
      #self.counter +=1
    #self.resetcounter()
    
class Reward:
  ''' A class that keeps updated the reward amount (duration of opening for valve and the nb of openings)
  '''
  def __init__(self,ID):
    self.amount= 50
    self.nbitems = 2
    self.ID = ID
    self.status = False
  def setamount(self,value):
    self.amount = value
  def setnbitems(self,value):
    self.nbitems=value



class CheckTouchBar(Thread):
  ''' A class that reads the U3-LV Labjack I/O to listen to status of manual sensor/touch bar
  '''
  def __init__(self,TouchBar,U3,Quitb,Maindict):
    Thread.__init__(self)
    self.Quitb = Quitb
    self.TouchBar = TouchBar
    self.Maindict = Maindict
    FIO5_DIR_REGISTER = 6105
    self.FIO5_STATE_REGISTER = 6005
    if len(U3)>0:
      self.U3 = U3[0]
      self.U3.writeRegister(FIO5_DIR_REGISTER, 0)
      self.labjackstatus = True
    else :
      self.labjackstatus = False
  def run(self):
    while (self.Quitb.empty()):
      if self.labjackstatus:
	if self.U3.readRegister(self.FIO5_STATE_REGISTER) != self.TouchBar.status:
	  self.TouchBar.setstatus(self.U3.readRegister(self.FIO5_STATE_REGISTER))
	  print 'change to %d ' % self.U3.readRegister(self.FIO5_STATE_REGISTER)
	  self.Maindict['touchbarstatus'] = int(not(bool(self.TouchBar.status))) # in Oxford Fiber Optic sensor is 'active low'
	  #self.Maindict['touchbarstatus']= self.TouchBar.status
	  self.Maindict['touchbarcouter'] = self.TouchBar.counter
	  #print self.TouchBar.status
    if self.labjackstatus:
      self.U3.close()
    print "Quit Check TouchBar"

class Check_MR_TTL_pulse(Thread):
  ''' A Class that checks continuously the MR TTL Pulse for new volumes we have implemented a change detection 
  as it seems to be the way the TTL pulse encodes new volume.
  '''
  def __init__(self,MR_TTL_pulse,U3,Quitb,Maindict):
    Thread.__init__(self)
    self.Quitb = Quitb
    self.MR_TTL_pulse = MR_TTL_pulse
    self.Maindict = Maindict
    FIO4_DIR_REGISTER = 6104 # to be adapted !!!
    self.FIO4_STATE_REGISTER = 6004 # to be adapted !!!
    if len(U3)>0:
      self.U3 = U3[0]
      #self.U3.writeRegister(FIO4_DIR_REGISTER, 0)
      self.labjackstatus = True
    else :
      self.labjackstatus = False
  def run(self):
    while (self.Quitb.empty()):
      if self.labjackstatus:
	#if self.MR_TTL_pulse.setstatus==1 and self.Maindict['MRTTLpulsecounter']==0:
	  #self.MR_TTL_pulse.resetcounter()
	if self.U3.readRegister(self.FIO4_STATE_REGISTER)==0 and self.MR_TTL_pulse.status:
	  self.MR_TTL_pulse.setstatus(0)
	  self.MR_TTL_pulse.incrementcounter()
	  #print 'change to'
	  self.Maindict['MRTTLpulsestatus'] = self.MR_TTL_pulse.status
	  self.Maindict['MRTTLpulsecounter'] = self.MR_TTL_pulse.counter
	  #time.sleep(0.1)
	elif self.Maindict['MRTTLpulsecounter']==0:
	  self.MR_TTL_pulse.setstatus(0)
	  self.MR_TTL_pulse.resetcounter()
	elif self.U3.readRegister(self.FIO4_STATE_REGISTER)==1 and not(self.MR_TTL_pulse.status):
	  self.MR_TTL_pulse.setstatus(1)
	  self.MR_TTL_pulse.incrementcounter()
	  self.Maindict['MRTTLpulsestatus'] = self.MR_TTL_pulse.status
	  self.Maindict['MRTTLpulsecounter'] = self.MR_TTL_pulse.counter
    if self.labjackstatus:
      self.U3.close()
    print "Quit Check_MR_TTL_pulse"
    
class WriteReward(Thread):
  ''' A Thread that write the reward (TTL value of 1) to the U3-LV labjack at each time the Reward if > 0
  '''
  def __init__(self,U3,Quitb,Maindict):
    Thread.__init__(self)
    self.Quitb = Quitb
    #self.Reward = Reward
    PORT = 6008
    self.server_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    self.server_socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    self.server_socket.bind(("", PORT))
    self.server_socket.listen(5)
    self.Quitb = Quitb
    self.Maindict= Maindict
    if len(U3)>0:
      self.U3 = U3[0]
      self.labjackstatus = True
    else :
      self.labjackstatus = False
  def run(self):
    while (self.Quitb.empty()):
      try :
	self.client_socket, address = self.server_socket.accept()
	print bcolors.OKBLUE+"WriteReward Got a connection from "+ address+ bcolors.ENDC
      except :
	do = 0
	#print bcolors.OKBLUE+'Server has been closed after the client'+ bcolors.ENDC
	#break;
      while (self.Quitb.empty()):
	self.dictloaded = cPickle.loads(self.client_socket.recv(512))
	self.client_socket.send(time.ctime())
	#print self.dictloaded['RewardValue']
	if self.Maindict['ON']==False:
	  self.Maindict['TotalRWD']=0
	if self.labjackstatus:
	  if self.dictloaded['RewardValue']>0:
	    self.Maindict['TotalRWD']+=1
	    print bcolors.OKBLUE+'Reward: %d, %d, %d' % (self.dictloaded['RewardValue'], self.dictloaded['RewardItems'],self.Maindict['TotalRWD'])+ bcolors.ENDC
	    #for nbr in range(0,self.dictloaded['RewardItems']+1):
	    for nbr in range(0,1):  
	      #self.Reward.status:
	      self.U3.setFIOState(6,1)
	      t0=time.time()
	      while (time.time()-t0)<self.dictloaded['RewardValue']/1000.:
		pass
	      self.U3.setFIOState(6,0)
	      #time.sleep(20/1000.) # interRWD interval
	    self.dictloaded['RewardValue']=0
	  #else:
	    #self.U3.setFIOState(6,0)
    if self.labjackstatus:
      self.U3.close()
    #self.Quitb.get()
    print "Quit Check Reward" 
    