#import 
import scipy.io.wavfile as w
from psychopy import sound
import numpy as np
from pylab import *

def createPsySound(arraysound,play=True,srate=22050,rfms=5):
  if max(arraysound)>1:
    arraysound = arraysound/(32000.0)
  if rfms>0:
    risefalltime_sp = int((float(rfms)/1000)*srate)
    arraysound[0:risefalltime_sp] = np.arange(0.0,1.0,1.0/risefalltime_sp)*arraysound[0:risefalltime_sp]
    arraysound[-risefalltime_sp:] = np.flipud(np.arange(0.0,1.0,1.0/risefalltime_sp))*arraysound[-risefalltime_sp:]
  soundA = sound.SoundPygame(arraysound,sampleRate=srate,bits=16)
  if play:
    soundA.play()
  return soundA
  
#createPsySound(data,srate=fs)

def plotsound(arraysound,fs):
  t = arange(0,len(arraysound),1)/(1.0*fs)
  plot(t,arraysound)
  xlabel('time (s)')
  ylabel('Wave')
  title('About as simple as it gets, folks')
  grid(True)
  #savefig("test.png")
  show()

if __name__ == '__main__':
  fs,data = w.read('basic_EPI.wav')
  #data =
  data = np.tile(data, 45)
  createPsySound(data,srate=fs)


