import Queue
from threading import Thread
import time
import socket
import string
import cPickle
from datetime import datetime
import copy
import array
import random

PORT = 6005
#IP = "169.254.10.188"
IP = "10.65.193.251"
IP = "localhost"
buffsize = 1024
Quitb = Queue.Queue()

    
class Stimuli(Thread):
  def __init__(self,Maindict,Quitb):
    Thread.__init__(self)
    self.client_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    self.client_socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    self.client_socket.connect((IP, PORT)) # Connect to behaviour Computer change localhost to the IP adress 
    self.Maindict = Maindict
    self.Quitb = Quitb
    
  def run(self):
    while self.Quitb.empty():
      self.dictloaded = copy.deepcopy(cPickle.loads(self.client_socket.recv(buffsize)))
      self.Maindict['ON'] = self.dictloaded['ON']
      self.Maindict['subject'] =  self.dictloaded['subject']
      self.Maindict['Eye'] = self.dictloaded['Eye']
      self.Maindict['RewardManual'] = self.dictloaded['RewardManual']
      self.Maindict['SaccadeDelay'] = self.dictloaded['SaccadeDelay']
      self.Maindict['Scale XY'] = self.dictloaded['Scale XY']
      self.Maindict['Offset XY'] = self.dictloaded['Offset XY']
      self.Maindict['record_eye'] = self.dictloaded['record_eye']
      self.Maindict['save_eye'] = self.dictloaded['save_eye'] 
      self.Maindict['clear_eye'] = self.dictloaded['clear_eye']
      self.Maindict['indexWin'] = self.dictloaded['indexWin']
      self.Maindict['touchbarstatus'] = self.dictloaded['touchbarstatus']
      self.Maindict['touchbarcouter'] = self.dictloaded['touchbarcouter']
      self.Maindict['targetpos'] = self.dictloaded['targetpos']
      self.Maindict['targetsize'] = self.dictloaded['targetsize']
      self.Maindict['targetindex'] = self.dictloaded['targetindex']
      self.Maindict['QuitTCP'] = self.dictloaded['QuitTCP']
      print self.Maindict
      #print 'Receiving %s at %s %.3d (ms)'% (data,  string.split(time.ctime(time.time()))[3],1000*(time.time()-int(time.time())))
      if (self.Maindict['QuitTCP']):
	print 'Closing client...'
	#self.client_socket.send (self.data)
	self.client_socket.shutdown('SHUT_RDWR')
	self.client_socket.close()
	break;
      else:
	self.client_socket.send(time.ctime())

class ClientReward(Thread):
  def __init__(self,Rewarddict,Quitb):
    Thread.__init__(self)
    PORT=6008
    self.client_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    self.client_socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    self.client_socket.connect((IP, PORT)) # Connect to behaviour Computer change localhost to the IP adress 
    self.Rewarddict = Rewarddict
    self.localdict = {'RewardValue':10, 'RewardItems':5}
    self.Quitb = Quitb

  def run(self):
    while self.Quitb.empty():
	if self.Rewarddict['RewardValue'] !=self.localdict['RewardValue']:
	  self.localdict['RewardValue'] = self.Rewarddict['RewardValue']
	  self.localdict['RewardItems'] = self.Rewarddict['RewardItems']
	  txt = '%d' % self.localdict['RewardValue']
	  self.client_socket.send(cPickle.dumps(self.localdict))
	  tmp = self.client_socket.recv(buffsize)
	  print tmp
    self.localdict['QuitTCP']=True
    self.client_socket.send(cPickle.dumps(self.localdict))
    time.sleep(2)
    print 'Quit TCP client'
    self.client_socket.close()  

class Task(Thread):
   def __init__(self,Quitb, Maindict,Rewarddict,trialstatus):
     Thread.__init__(self)
     self.Quitb = Quitb
     self.Rewarddict=Rewarddict
     self.Maindict = Maindict
     self.timertrial=0
     self.trialstatus = trialstatus
     self.maxRT = 800
     self.HoldTime = 4200
     self.ITTime = 300
   def run(self):
     while (self.Quitb.empty()):
       if self.Maindict['ON']:
	if self.trialstatus['status'] == 'OFF':
	  print 'InterTrial'
	  time.sleep(self.ITTime/1000.)
	  self.trialstatus['status'] = 'prep'
	  print 'Trial Start'
	elif self.trialstatus['status']=='prep' :
	  timertrial = time.time()
	  while self.Maindict['touchbarstatus']==1:
	    if (time.time()-timertrial)>=self.HoldTime/1000. and self.Maindict['indexWin'][0]==1:
	      print 'goes to black'
	      self.trialstatus['status']='Cue'
	      break
	    elif self.Maindict['indexWin'][0]==0:
	      print 'abort'
	      self.trialstatus['status'] = 'OFF'
	      break
	if self.trialstatus['status']=='Cue' and self.Maindict['indexWin'][0]==1: # and self.Maindict['touchbarstatus']
	  timer = time.time()
	  print 'Cue ON'
	  while (time.time()-timer)<(self.maxRT/1000.):
	    if not(self.Maindict['touchbarstatus']):
	      print 'you were fast enough'
	      self.Rewarddict['RewardValue'] = random.randint(120, 130)
	      print self.Rewarddict['RewardValue']
	      self.trialstatus['status'] = 'OFF'
	      break
	  self.trialstatus['status'] = 'OFF'
       else :
	 self.trialstatus['status'] = 'OFF'
	#else :
	  #self.trialstatus = 'OFF'
     #self.Quitb.get()
     print "Quit Task" 

class TaskTouchonly(Thread):
   def __init__(self,Quitb, Maindict,Rewarddict,trialstatus):
     Thread.__init__(self)
     self.Quitb = Quitb
     self.Rewarddict=Rewarddict
     self.Maindict = Maindict
     self.timertrial=0
     self.trialstatus = trialstatus
     self.maxRT = 700
     self.HoldTime = 4200
     self.ITTime = 600
   def run(self):
     while (self.Quitb.empty()):
       if self.Maindict['ON']:
	if self.trialstatus['status'] == 'OFF':
	  print 'InterTrial'
	  time.sleep(self.ITTime/1000.)
	  self.trialstatus['status'] = 'prep'
	  print 'Trial Start'
	elif self.trialstatus['status']=='prep' :
	  timertrial = time.time()
	  while self.Maindict['touchbarstatus']==1:
	    if (time.time()-timertrial)>=(self.HoldTime+random.randint(-200, 200))/1000.:
	      print 'goes to black'
	      self.trialstatus['status']='Cue'
	      break
	    #elif self.Maindict['indexWin'][0]==0:
	      #print 'abort'
	      #self.trialstatus['status'] = 'OFF'
	      #break
	if self.trialstatus['status']=='Cue': # and self.Maindict['touchbarstatus']
	  timer = time.time()
	  print 'Cue ON'
	  while (time.time()-timer)<(self.maxRT/1000.):
	    if not(self.Maindict['touchbarstatus']):
	      print 'you were fast enough'
	      self.Rewarddict['RewardValue'] = random.randint(120, 130)
	      print self.Rewarddict['RewardValue']
	      self.trialstatus['status'] = 'OFF'
	      break
	  self.trialstatus['status'] = 'OFF'
       else :
	 self.trialstatus['status'] = 'OFF'
	#else :
	  #self.trialstatus = 'OFF'
     #self.Quitb.get()
     print "Quit Task"
     
from psychopy import visual, core, event

class Display(Thread):
  def __init__(self,Quitb,trialstatus,Maindict):
    Thread.__init__(self)
    self.Quitb = Quitb
    self.trialstatus = trialstatus
    self.Maindict = Maindict
    self.mainloop = True
  def run(self):
    #win2 = visual.Window((1280, 1024), allowGUI=True,  bitsMode=None,  units='pix', winType='pyglet', screen=1, pos=(+1680, 18),fullscr=True,color=(0, 0, 0))
    win2 = visual.Window((640, 512), allowGUI=True,  bitsMode=None,  units='pix', winType='pyglet', screen=0, pos=(+1680, 0),fullscr=False,color=(0, 0, 0))
    #pos=(+1680, 0)q
    self.fixpoint = visual.PatchStim(win=win2,  units='pix', size=9, pos=[0, 0], sf=0, color=(1, -1, -1),colorSpace='rgb')
    colsquare = (1,0,0)
    #colsquare = (1,1,1)
    contrast = 0.8
    while (self.Quitb.empty()):
      while self.mainloop:
	if self.trialstatus['status']=='OFF':
	  self.fixpoint.setColor((0, 0, 0))
	elif self.trialstatus['status']=='prep':
	  self.fixpoint.setColor(tuple([contrast*x for x in colsquare]))
	elif self.trialstatus['status']=='Cue':
	  self.fixpoint.setColor(tuple([-contrast*x for x in colsquare]))
	#if self.Maindict['touchbarstatus']==1:
	  #self.fixpoint.setColor((1, -1, -1))
	#else :
	  #self.fixpoint.setColor((-1, 1, -1))
	self.fixpoint.setSize(self.Maindict['targetsize'])
	self.fixpoint.setPos(self.Maindict['targetpos'])
	self.fixpoint.draw()
	win2.flip()
	for key in event.getKeys():
	  if key in ['escape', 'q']:
	    self.mainloop = False
	    win2.close()
	    Quitb.put('stopit')
	    core.quit()
	    
class TaskFixOnly(Thread):
   def __init__(self,Quitb, Maindict,Rewarddict,trialstatus):
     Thread.__init__(self)
     self.Quitb = Quitb
     self.Rewarddict=Rewarddict
     self.Maindict = Maindict
     self.timertrial=0
     self.trialstatus = trialstatus
     self.maxRT = 800
     self.HoldTime = 700
     self.ITTime = 200
   def run(self):
     while (self.Quitb.empty()):
       if self.Maindict['ON']:
	if self.trialstatus['status'] == 'OFF':
	  print 'InterTrial'
	  time.sleep(self.ITTime/1000.)
	  self.trialstatus['status'] = 'prep'
	  print 'Trial Start'
	  #print self.Maindict['indexWin'][0]
	elif self.trialstatus['status']=='prep' :
	  timertrial = time.time()
	  while self.Maindict['indexWin'][self.Maindict['targetindex']]==1:
	    if (time.time()-timertrial)>=self.HoldTime/1000.:
	      print 'goes to black'
	      self.trialstatus['status']='Cue'
	      break
	    #elif self.Maindict['indexWin'][0]==0:
	      #print 'abort'
	      #self.trialstatus['status'] = 'OFF'
	      #break
	elif self.trialstatus['status']=='Cue' and self.Maindict['indexWin'][self.Maindict['targetindex']]==1: # and self.Maindict['touchbarstatus']
	  timer = time.time()
	  time.sleep(200/1000.)
	  print 'Cue ON'
	  self.Rewarddict['RewardValue'] = random.randint(90, 110)
	  print self.Rewarddict['RewardValue']
	  self.trialstatus['status'] = 'OFF'
	else :
	 self.trialstatus['status'] = 'OFF'
	#else :q
	  #self.trialstatus = 'OFF'
     #self.Quitb.get()
     print "Quit Task" 	  



trialstatus = {'status':'OFF'}

Maindict={
'ON':False,
'subject':'',
'Eye': [False, False, False],
'RewardManual':50,
'SaccadeDelay':280, 
'Scale XY':[1, 1], 
'Offset XY':[0, 0], 
'record_eye':False, 
'save_eye':False, 
'clear_eye':False, 
'indexWin':array.array('H'), 
'touchbarstatus':0, 
'touchbarcouter':0, 
'targetindex':0, 
'targetpos':[0,0], 
'targetsize':7 
}

Rewarddict = {
'RewardValue':10,
'RewardItems':3
}




indextask = 0
listofTask = []
listofTask.append(TaskTouchonly(Quitb,Maindict,Rewarddict,trialstatus))
listofTask.append(Task(Quitb,Maindict,Rewarddict,trialstatus))
listofTask.append(TaskFixOnly(Quitb,Maindict,Rewarddict,trialstatus))
listofTask[indextask].start()


try:
  Reward = ClientReward(Rewarddict,Quitb)
  Reward.start()
except:
  print 'Could not start the TCP client for Reward'
try:
  client = Stimuli(Maindict,Quitb)
  client.start()
except:
  print 'Could not start the TCP client for Stimuli'
  

#import stimout
try:
  disp =  Display(Quitb,trialstatus,Maindict)
  disp.start()
except:
  print 'Could not start the Stimulation Display'


