import numpy as np
import iso226 as iso
from scipy import interpolate
from psychopy import sound
import scipy.io.wavfile as w
import datetime
import os
'''
TONOTOPIC MAPPING STIMULI, traveling wave
frequency progressions from low-to-high or high-to-low.

Multiple bursts of each frequency are presented for 2s blocks,
before stepping to the next frequency.
9x2 seconds of sound (18s) followed by 12 sec of silent rest = 30 sec cycles.
Cycle repeated 15 times = 8 min.

During each 2s block, tone bursts of the same frequency are played in
a pseudorandomized rythmic pattern similar to Morse code
Short (50ms) and long (200ms) tone bursts are randomly intermixed, and
verified to have at least 4 transitions between short and long to
impose a rhymic pattern.  A rhythmic pattern makes the tone stimuli more salient over the fixed pattern scanner
noise.
Adapted from Matlab code authored by Melissa Saenz -saenz.melissa@gmail.com
Current version - Feb. 2013 Olivier Joly olivier.j.joly@gmail.com
''' 

def Tonotopy4(direction=1):
  tones = np.asarray([500, 707, 1000, 1414, 2000, 2828, 4000, 5657, 8000])   # in Hz
  tones = np.asarray([np.int(np.round(500.*2**x)) for x in  np.arange(0,4.5,0.5)])
  # use this to get the equal loundness curve of desired phon for calibration
  spl, freq = iso.iso226(70)
  #equal_phon_levels = interpolate.UnivariateSpline(freq,spl,tones)
  equal_phon_levels = interpolate.interp1d(freq, spl, kind='cubic')(tones)
  #ctonevals = np.asarray([88, 125, 177, 250, 354, 500, 707, 1000, 1414, 2000, 2828, 4000, 5657, 8000]) # frequencies tested during calibration  
  ctonevals = tones
  #clevels = np.asarray([.15, 0.2, .15, 0.1, .07,  0.05, 0.04, 0.03, .03, 0.03, .03, 0.03, .05, 1]) # relative strenghts to acheive equal phon
  clevels = equal_phon_levels/np.float(np.max(equal_phon_levels))
  # adjust output based on calibration vals 
  #if direction==1:
  tones = tones    #frequencies in the stimulus
  levels = interpolate.interp1d(ctonevals, clevels, kind='cubic')(tones)#interpolate to make a calibration curve
  if direction==2:
    tones = tones[::-1]#np.fliplr(tones)  # flip the order of frequencies if dir=2
    #ctonevals = ctonevals[::-1]
    levels = levels[::-1] 
    #levels = interpolate.interp1d(ctonevals,clevels, kind='cubic')(tones)#
    
  #  Duration of each tone burst
  pulse_dur = np.asarray([0.05, 0.2]) #  seconds, duration of short and long tone bursts, respectively
  off_dur = 0.05 # seconds, duration between tone bursts
  TR = 2 
  block_dur = TR #  seconds, duration of each frequency block 
  nBursts = 30#8 # number of bursts of the same frequency in a block
  pausetime = 0 #0.5*block_dur # seconds, silent pause between cycles
  silenttime = 6*block_dur
  cycle_dur = block_dur*len(tones)+pausetime
  ncycles = 15
  scan_time = cycle_dur*ncycles  #seconds
  nVolumes = scan_time/block_dur #number to 2s volume acquisitions
  print 'Nb of volumes : %f ' % nVolumes
  print 'TR : %f ' % TR
  directionstring = ['L-H', 'H-L']
  print 'Direction : %s' % directionstring[direction-1]
  print tones
  max_length = block_dur*44100
  ncyclesarr = np.asarray([])
  for i in np.arange(0,ncycles):   # loop through all cycles  
      cycle = np.asarray([])
      for t in np.arange(0,len(tones)):  # loop through blocks of each frequency (n = 14)
	tone_sequence = np.asarray([])
	burstseq = makeburstseq(nBursts) # generate a new rythmic pattern of short and long bursts every block
	for s in np.arange(0,nBursts):
	  pts = np.arange(0,pulse_dur[burstseq[s]],1/44100.)
	  tpin = np.sin(2*np.pi*tones[t]*pts)
	  tpins= tpin*levels[t]
	  singleburst = taper(tpins,0.2)
	  tone_sequence = np.hstack([tone_sequence, singleburst, np.zeros(off_dur*44100)])  # combine into a sound sequence
	  #tone_sequence = tmp 
	  #double check to make sure tone_seqeunce doesn't exceed the 
	  #block_dur (i.e. too many long bursts), if so trim it.
	if len(tone_sequence) > max_length:
	  tone_sequence = tone_sequence[1:max_length]
	  #print 'tone sequence exceeded block length'
	  #tone_sequence[-1542:] = np.tone_sequence[-1542:
	  lxr = 1542
	  tone_sequence[-lxr:] = tone_sequence[-lxr:] * (0.5+0.5*np.cos(np.arange(0,lxr)*np.pi/np.float(lxr))) 
	elif len(tone_sequence) < max_length:
	  tone_sequence = np.hstack([tone_sequence,np.zeros(max_length-len(tone_sequence))])
	cycle = np.hstack([cycle,tone_sequence])
	cycle = np.hstack([cycle,np.zeros(pausetime*44100)])
      if len(ncyclesarr)>0:
	#ncyclesarr = np.hstack([ncyclesarr,cycle])
	ncyclesarr = np.hstack([ncyclesarr,np.zeros(silenttime*44100),cycle])
      else:
	ncyclesarr = cycle  
  #ncyclesarr = np.hstack([ncyclesarr,np.zeros(pausetime*44100)])
  #ncyclesarr = np.hstack([ncyclesarr,np.zeros(pausetime*44100)])
  dd = 32000*ncyclesarr
  sounddata = np.asarray([dd.astype('int16'),dd.astype('int16')]).T
  now = datetime.datetime.now()
  dirout = '/home/guest/audiostim/%s' % now.strftime("%Y_%m_%d")
  if not(os.path.exists(dirout)):
    os.mkdir(dirout)
    print 'create directory : %s' % dirout
  else:
    print 'Directory %s already exists' % dirout
  outname = '%s/tono4_cylces_%d_%s.wav' % (dirout,direction,now.strftime("%Y_%m_%d_%H_%M"))
  print outname
  w.write(outname,44100,sounddata)
  #,ncyclesarr,levels
  return sound.Sound(ncyclesarr, sampleRate=44100, bits=16)
  
  
def makeburstseq(nBursts):
  #[burstseq] = makeburstseq(nBursts)
  #%generate 8-element ryhthmic sequences with at least 4 switches
  validseq = False
  while not(validseq):
    burstseq = np.round(np.random.rand(nBursts))
    switches = 0
    for b in xrange(0,len(burstseq)-1):
      if not(burstseq[b]==burstseq[b+1]):
	switches = switches+1
    if switches>=4:
      validseq=1
  #print burstseq 
  return burstseq 
          
def taper(x,frac):
  #function x = taper(x,frac)
  #tapers edges of each noise burst 
  lenx = round(len(x) * frac)
  #print lenx
  x[0:lenx] = x[0:lenx] * (0.5 - 0.5*np.cos(np.arange(0,lenx)*np.pi/lenx))
  x[-lenx:] = x[-lenx:] * (0.5+0.5*np.cos(np.arange(0,lenx)*np.pi/np.float(lenx)))
  return x
 
