#!/usr/bin/env python
"""
Example of code that would be used for most of the training task to encourage for longer session, the main goal is to give a feedback of the time expected 
in the training setup which is defined as a weighted combination of duration and number of trials. 
--
Author: Olivier Joly, PhD 
Email: olivier.j.joly@gmail.com 
Last update: 26 Nov. 2013, Oxford, UK
"""
from psychopy import visual, core, misc, event
import numpy 

# ------------------------------- Main variables (to put in the primatepy GUI) ----------
N = 142 # number of dots in one row
nrow = 3 # number of rows in the display of dots, typically between 1-5
totaltrials = N*nrow
fieldSize = 650 # must be smaller that the window max dimension
ratioY = 130
elemSize = 14 # size of the dots
Ypos = 10 # Y pos from the bottom side of the screen
totalduration_training = 1*3600 # defines the total duration of the training in sec. <<<<<<<<<< Important parameter
trialsdone_and_timebonus = 0
timeforbonus = totalduration_training/numpy.float(N*nrow) # defines the duration between 2 bonus (free trials)
remaining_trials = totaltrials - trialsdone_and_timebonus
# -------------------------------
# Define the positions of all the dots :
XYS = numpy.vstack(((numpy.arange(0,N)/numpy.float(N)).repeat(nrow), numpy.tile((numpy.arange(Ypos,Ypos+nrow)/numpy.float(ratioY)),(N)))).T
# Define the colors of all the dots (green for trials done and light grey for remaining trials) :
C = numpy.vstack((numpy.tile([-1,0.9,-1],(1,trialsdone_and_timebonus)).reshape(trialsdone_and_timebonus,3),numpy.tile([0.35,0.35,0.35],(1,remaining_trials)).reshape(remaining_trials,3)))
# -------------------------------

win = visual.Window([1024,768], units='pix', monitor='testMonitor',fullscr =False) # Our window for now
''' The folowwing 'stimulus' can draw thousands of elements without dropping a frame, 
but in order to achieve this performance, uses several OpenGL extensions only available on modern graphics cards (supporting OpenGL2.0)
build a standard (but dynamic!) global form stimulus. We will only update the colors (array C) during the training
'''
train_prog_bar = visual.ElementArrayStim(win, nElements=totaltrials,sizes=elemSize,sfs=0,
                                                    xys = XYS*fieldSize-fieldSize/2.0,
                                                    colors=C,colorSpace='rgb',opacities=1,elementMask='gauss') 
# -------------------------------
clock = core.Clock()
t0 = clock.getTime()
while True:
    if (clock.getTime()-t0)>timeforbonus and remaining_trials>0:
        trialsdone_and_timebonus+=1
        remaining_trials = totaltrials - trialsdone_and_timebonus
        t0 = clock.getTime()
	C = numpy.vstack((numpy.tile([-1,0.9,-1],(1,trialsdone_and_timebonus)).reshape(trialsdone_and_timebonus,3),numpy.tile([0.35,0.35,0.35],(1,remaining_trials)).reshape(remaining_trials,3)))
    train_prog_bar.setColors(C)
    train_prog_bar.draw()
    #win.getMovieFrame()
    win.flip()
    #handle key presses each frame
    for key in event.getKeys():
        if key in ['escape','q']:
            #win.saveMovieFrames('/home/guest/training_progress_nhp.tif')
            win.close()
            core.quit()
    event.clearEvents('mouse') #only really needed for pygame windows
    