import numpy as np
import matplotlib.mlab as mlab
import matplotlib.pyplot as plt
import os
import runpy
from pyPdf import PdfFileWriter, PdfFileReader
import re

#import datalog_2012_01_23_12_26

# pB = np.asarray(playB)
# a = np.asarray(answer)
def append_pdf(input,output):
    [output.addPage(input.getPage(page_num)) for page_num in range(input.numPages)]




  
def cctnallpdf(filetxt):
  basicfilter = os.path.basename(filetxt).replace('.txt','')
  outpdf = '%s/all_%s' % (os.path.dirname(filetxt),os.path.basename(filetxt).replace('.txt','.pdf'))
  try:
    os.remove(outpdf)
  except:
    ok=0
  dirn = os.path.dirname(os.path.abspath(filetxt))
  print dirn
  folderCount = 0
  allfiles = []
  for root, subFolders, files in os.walk(dirn):
    folderCount += len(subFolders)
    for filef in files:
        f = os.path.join(root,filef)
        #fileSize = fileSize + os.path.getsize(f)
        #print(f)
        allfiles.append(f)
        
  tr  = ".pdf$" 
  filterdef = re.compile(tr, re.IGNORECASE)
  files = filter(filterdef.search, allfiles)
  tr = '%s' % basicfilter
  filterdef = re.compile(tr, re.IGNORECASE)
  subsetfiles = filter(filterdef.search, files)
  print subsetfiles
  output = PdfFileWriter()
  for f in subsetfiles:
    #print type(f)
    inp = PdfFileReader(file(f,"rb"))
    append_pdf(inp,output)
    
  output.write(file(outpdf,"wb"))
  print outpdf
def converttxt2py(filetxt):
  outn = os.path.abspath(filetxt).replace('.txt','.py')
  cmd = 'more %s | grep py  | awk \'{print $3\" \"$4\" \"$5 \" \"$6}\'> %s' % (filetxt,outn)
  #cmd = 'filterlog %s %s' % (filetxt,outn)
  #print cmd
  os.system(cmd)
  return outn
def convertOLDtxt2py(filetxt):
  cmd = 'filterlogfromold %s' % filetxt
  #print cmd
  os.system(cmd)

def plotRT(filepy):
  dictdata = runpy.run_path(filepy)
  hit = np.asarray(dictdata['py_hit'])
  pB = np.asarray(dictdata['py_playB'])
  plt.subplot(211)
  n, bins, patches = plt.hist(hit[:,0], 70, normed=1, facecolor='green', alpha=0.75)
  y = mlab.normpdf( bins, hit[:,0].mean(), hit[:,0].std())
  l = plt.plot(bins, y, 'r--', linewidth=1)
  plt.xlabel('Time (s)')
  plt.ylabel('Frequency')
  plt.title('Reaction Time')
  plt.axis([0, 2, 0, 5])
  plt.grid(True)
  #plt.show()
  plt.subplot(212)
  n, bins, patches = plt.hist(pB[:,0], 70, normed=1, facecolor='green', alpha=0.75)
  #y = mlab.normpdf( bins, pB.mean(), pB.std())
  #l = plt.plot(bins, y, 'r--', linewidth=1)
  plt.xlabel('Time (s)')
  plt.ylabel('Frequency')
  plt.title('Hold Time')
  plt.axis([0, 3, 0, 3])
  plt.grid(True)
  plt.show()

def plotRT_pdf(filepy):
  filout = filepy.replace('.py','_RT_Hold_dist_.pdf')
  dictdata = runpy.run_path(filepy)
  hit = np.asarray(dictdata['py_hit'])
  pB = np.asarray(dictdata['py_playB'])
  fig = plt.figure(figsize=(11,8.5))
  plt.subplot(211)
  n, bins, patches = plt.hist(hit[:,0], 70, normed=1, facecolor='green', alpha=0.75)
  y = mlab.normpdf( bins, hit[:,0].mean(), hit[:,0].std())
  l = plt.plot(bins, y, 'r--', linewidth=1)
  plt.xlabel('Time (s)')
  plt.ylabel('Frequency')
  plt.title('Reaction Time')
  plt.axis([0, 2, 0, 5])
  plt.grid(True)
  #plt.show()
  plt.subplot(212)
  n, bins, patches = plt.hist(pB[:,0], 70, normed=1, facecolor='green', alpha=0.75)
  #y = mlab.normpdf( bins, pB.mean(), pB.std())
  #l = plt.plot(bins, y, 'r--', linewidth=1)
  plt.xlabel('Time (s)')
  plt.ylabel('Frequency')
  plt.title('Hold Time')
  plt.axis([0, 3, 0, 3])
  plt.grid(True)
  plt.savefig(filout, format='pdf', papertype="a4", orientation='landscape') # facecolor='y',
  plt.close()


def getfitRT(filepy):
  '''
  This function is using R to fit a InvGaussian to the reaction time data.
  mu seems to be a good estimation of the reaction time
  '''
  from rpy2 import robjects
  from rpy2.robjects.lib import grid
  from rpy2.robjects.packages import importr
  import rpy2.robjects.numpy2ri as n
  # The R 'print' function
  rprint = robjects.globalenv.get("print")
  stats = importr('stats')
  grdevices = importr('grDevices')
  base = importr('base')
  ghyp = importr('ghyp')
  #cmd = 'python %s' % filepy
  dictdata = runpy.run_path(filepy)
  #os.system(cmd)
  hit = np.asarray(dictdata['py_hit'])
  #print len(hit)
  hit = n.numpy2ri(hit[:,0])
  nig_fit = ghyp.fit_NIGuv(hit,mu=True, sigma=True, gamma=True)
  grdevices = importr('grDevices')
  filout = filepy.replace('.py','.pdf')
  grdevices.pdf(file=filout,paper='a4r')
  robjects.r('par(mfrow=c(1, 1),las=1)')
  rhist= robjects.r('hist')
  maintxt = 'Histogram of RTs (%s)' % os.path.basename(filepy)
  reh = rhist(nig_fit,xlab="Reaction Time (RT, in secs)",main = maintxt)
  #hist(nig.fit,xlab="Reaction Time (RT, in secs)",main = paste("Histogram of" , "RTs"))
  rcoef= robjects.r('coef')
  mu = rcoef(nig_fit)
  e = np.asarray(rprint(mu[2]))
  t = 'Mean RT(mu) = %3dms' % (1000*e)
  rmt = robjects.r('mtext')
  rmt(t)
  grdevices.dev_off()


#run datalog_2012_02_01_09_57.py


#trialstart = np.asarray(py_trialstart)
#miss = np.asarray(py_miss)
#hit = np.asarray(py_hit)
#false_alarm = np.asarray(py_false_alarm)
#correct_rejection = np.asarray(py_correct_rejection)


def rate_evolution(filepy,step=5):
  '''
  This function is intended to return the evolution of hit rate and false alarm rate accross the session with the specified step (in sec).
  '''
  dictdata = runpy.run_path(filepy)
  miss = np.asarray(dictdata['py_miss'])
  hit = np.asarray(dictdata['py_hit'])
  false_alarm = np.asarray(dictdata['py_false_alarm'])
  correct_rejection = np.asarray(dictdata['py_correct_rejection'])
  trialstart = np.asarray(dictdata['py_trialstart'])
  #print len(correct_rejection) 
  #print len(hit)
  #print len(false_alarm)
  #print len(miss)
  maxTime = np.int(np.ceil(max(trialstart[:,1])))
  minTime = np.int(np.floor(min(trialstart[:,1])))
  print 'Min Max Time : %d %d' % (minTime,maxTime)
  evol_rate = []
  hitrate = 0
  false_alarm_rate = 0
  timestep = range(minTime,maxTime,step)
  for mxT in timestep:
    if len(miss)>0:
      lm = np.shape(np.where(miss[:,1]<mxT))[-1]
    else : 
      lm = 0
    if len(hit)>0:
      lh = np.shape(np.where(hit[:,1]<mxT))[-1]
    else : 
      lh = 0
    if len(false_alarm)>0:
      lf = np.shape(np.where(false_alarm[:,1]<mxT))[-1]
    else :
      lf = 0
    if len(correct_rejection)>0:
      lc =np.shape(np.where(correct_rejection[:,1]<mxT))[-1]
    else :
      lc = 0
    if lh+lm>0:
      hitrate = 100*(np.float(lh)/(lh+lm))
    if lf+lc>0:
      false_alarm_rate = 100*(np.float(lf)/(lf+lc))
    evol_rate.append([hitrate,false_alarm_rate])
  erate = np.asarray(evol_rate)
  filout = filepy.replace('.py','_erate.pdf')
  fig = plt.figure(figsize=(11,8.5))
  plt.plot(timestep,erate[:,0], 'b', linewidth=2,label='Hit rate')
  plt.plot(timestep,erate[:,1], 'r', linewidth=2,label='False alarm rate')
  plt.xlabel('Time (s)')
  plt.ylabel('Percentage')
  ttext = 'Evolution of Perf. (%d trials; %s)' % (lh+lm+lf+lc,os.path.basename(filepy))
  plt.title(ttext)
  plt.axis([minTime, maxTime, 0, 100])
  plt.grid(True)
  #plt.show()
  lb1 = 'Hit rate (%.2f%% test trials)' % (100*float(lh+lm)/(lh+lm+lf+lc))
  lb2 = 'False alarm rate (%.2f%% catch trials)' % (100*float(lf+lc)/(lh+lm+lf+lc))
  plt.legend(('Hit rate (%dtest trials)', 'False alarm rate (catch trials)'),loc=7)
  plt.legend((lb1,lb2),loc=7)
  plt.savefig(filout, format='pdf', papertype="a4", orientation='landscape') # facecolor='y',
  plt.close()
  return erate
    
  

def pyhit(filepy,timewin=True,Tmin=0,Tmax=None,dprime=True):
  filout = filepy.replace('.py','_hitfreq.pdf')
  dictdata = runpy.run_path(filepy)
  #miss = np.asarray(dictdata['py_miss'])
  Fa = 1000
  hit = np.asarray(dictdata['py_hit'])
  playB = np.asarray(dictdata['py_playB'])
  if timewin:
    hit = hit[np.asarray([hit[:,1]<Tmax, hit[:,1]>Tmin]).all(axis=0)]
    #hit = hit[hit[:,1]<Tmax,:]
    playB = playB[np.asarray([playB[:,1]<Tmax, playB[:,1]>Tmin]).all(axis=0)]
  arrayfreq = np.unique(playB[:,2])
  hitrate_freq = []
  for fr in arrayfreq:
    pc = np.float(np.shape(np.where(hit[:,2]==fr))[-1])/np.shape(np.where(playB[:,2]==fr))[-1]
    hitrate_freq.append([100*pc,fr])
    nbt_fr = np.shape(np.where(playB[:,2]==fr))[-1]
    print 'Freq %dHz\t%.2f%%\t(%d trials)' % (fr, 100*pc, nbt_fr)
  
  HR_freq = np.asarray(hitrate_freq)
  fig = plt.figure(figsize=(11,8.5))
  plt.plot(HR_freq[:,1]-Fa,HR_freq[:,0], 'bo', linewidth=2,label='Hit rate')
  plt.plot(HR_freq[:,1]-Fa,HR_freq[:,0], 'b--', linewidth=2)
  plt.axis([1, np.max(arrayfreq)-Fa, 0, 110])
  plt.xscale('log',basex=2)
  ax = fig.axes
  zd = ax[0]
  valxaxis = np.logspace(0, np.log2(np.max(arrayfreq)-Fa), num=np.log2(np.max(arrayfreq)-Fa)+1, endpoint=True, base=2.0)
  #print valxaxis
  txtvalxaxis = ['%d' % x for x in valxaxis]
  print txtvalxaxis 
  zd.set_xticklabels(txtvalxaxis)
  #plt.plot(timestep,erate[:,1], 'r', linewidth=2,label='False alarm rate')
  plt.xlabel(r'$+\Delta F (Hz)$')
  plt.ylabel('Percentage')
  ttext = 'Perf. (%d Hz,%s,<%d)' % (Fa,os.path.basename(filepy),Tmax)
  plt.title(ttext)
  #plt.axis([min(arrayfreq), max(arrayfreq), 0, 100])
  
  plt.grid(True)
  #plt.show()
  lb1 = 'Hit rate'
  #(%.2f%% test trials)' % (100*float(lh+lm)/(lh+lm+lf+lc))
  #lb2 = 'False alarm rate (%.2f%% catch trials)' % (100*float(lf+lc)/(lh+lm+lf+lc))
  #plt.legend(('Hit rate (%dtest trials)', 'False alarm rate (catch trials)'),loc=7)
  #plt.legend(lb1,loc=7)
  plt.savefig(filout, format='pdf', papertype="a4", orientation='landscape') # facecolor='y',
  plt.close()
  
  return hit, HR_freq



def rate_evolutionpercond(filepy,step=25,dprime=True):
  '''
  This function is intended to return the evolution of hit rate and false alarm rate accross the session with the specified step (in sec).
  '''
  if dprime:
    from rpy2 import robjects
    from rpy2.robjects.lib import grid
    from rpy2.robjects.packages import importr
    psyphy = importr('psyphy')
    import rpy2.robjects.numpy2ri as n
    rprint = robjects.globalenv.get("print")
    stats = importr('stats')
    #grdevices = importr('grDevices')
    base = importr('base')
    #ghyp = importr('ghyp')
  dictdata = runpy.run_path(filepy)
  miss = np.asarray(dictdata['py_miss'])
  hit = np.asarray(dictdata['py_hit'])
  playB = np.asarray(dictdata['py_playB'])
  arrayfreq = np.unique(playB[:,2])
  
  false_alarm = np.asarray(dictdata['py_false_alarm'])
  correct_rejection = np.asarray(dictdata['py_correct_rejection'])
  trialstart = np.asarray(dictdata['py_trialstart'])
  #print len(correct_rejection) 
  #print len(hit)
  #print len(false_alarm)
  #print len(miss)
  maxTime = np.int(np.ceil(max(trialstart[:,1])))
  minTime = np.int(np.floor(min(trialstart[:,1])))
  print 'Min Max Time : %d %d' % (minTime,maxTime)
  colorarray = ['r','g','y','black','m','b']
  hitrate = 0
  false_alarm_rate = 0
  erate = []
  lballs = []
  timestep = range(minTime,maxTime,step)
  for fr in arrayfreq:
    missfr = miss[miss[:,2]==fr,:]
    hitfr = hit[hit[:,2]==fr,:]
    false_alarmfr = false_alarm
    correct_rejectionfr = correct_rejection
    evol_rate = []
    for mxT in timestep:
      if len(missfr)>0:
	lm = np.shape(np.where(missfr[:,1]<mxT))[-1]
      else : 
	lm = 0
      if len(hitfr)>0:
	lh = np.shape(np.where(hitfr[:,1]<mxT))[-1]
      else : 
	lh = 0
      if len(false_alarmfr)>0:
	lf = np.shape(np.where(false_alarmfr[:,1]<mxT))[-1]
      else :
	lf = 0
      if len(correct_rejectionfr)>0:
	lc =np.shape(np.where(correct_rejectionfr[:,1]<mxT))[-1]
      else :
	lc = 0
      if lh+lm>0:
	hitrate = 100*(np.float(lh)/(lh+lm))
      if lf+lc>0:
	false_alarm_rate = 100*(np.float(lf)/(lf+lc))
      evol_rate.append([hitrate,false_alarm_rate])
    erate.append(np.asarray(evol_rate))
    
  filout = filepy.replace('.py','_erateperfreq.pdf')
  fig = plt.figure(figsize=(11,8.5))
  ind = 0
  for edata in erate:
    fr = arrayfreq[ind]
    #local_label = '%d Hz' % fr
    if dprime:
      #print edata[-1,0]
      #print edata[-1,1]
      H = n.numpy2ri(edata[-1,0]/100)
      FA = n.numpy2ri(edata[-1,1]/100)
      dprime = psyphy.dprime_SD(H,FA)
      d = np.asarray(rprint(dprime))
      local_label = '%.2f' % (d)
      lballs.append('HR %d(Hz),d\'=%.2f' % (fr,d))
    else:
      local_label = '%d' % (fr)
      lballs.append('HR %d(Hz)' % (fr))
    plt.plot(timestep,edata[:,0], colorarray[ind], linewidth=2,label=local_label)
    ind += 1
  plt.plot(timestep,edata[:,1], 'r--', linewidth=2,label='FA rate')
  plt.xlabel('Time (s)')
  plt.ylabel('Percentage')
  ttext = 'Evolution of Perf. (%s)' % (os.path.basename(filepy))
  plt.title(ttext)
  plt.axis([minTime, maxTime, 0, 110])
  plt.grid(True)
  #plt.show()
  lb1 = 'Hit rate (%.2f%% test trials)' % (100*float(lh+lm)/(lh+lm+lf+lc))
  lballs.append('False alarm rate')
  #plt.legend(('Hit rate (%dtest trials)', 'False alarm rate (catch trials)'),loc=4)
  plt.legend(tuple(lballs),loc=4)
  plt.savefig(filout, format='pdf', papertype="a4", orientation='landscape') # facecolor='y',
  plt.close()
  return erate



def allfromtxt(filetxt,Tmax=None):
  y = converttxt2py(filetxt)
  plotRT_pdf(y)
  getfitRT(y)
  pyhit(y,timewin=True, Tmin=0, Tmax=Tmax)
  rate_evolution(y)
  rate_evolutionpercond(y,dprime=False)
  cctnallpdf(filetxt)



def py2mat(filepy):
  ''' py2mat converts a .py into a .mat file for analyses in matlab
  '''
  import types
  import scipy.io.matlab as m
  #from copy import deepcopy
  outn = filepy.replace('.py','.mat')
  dictdata = runpy.run_path(filepy)
  cpdictdata = dict()
  for field in dictdata:
    if isinstance(dictdata[field], types.ListType):
      cpdictdata[field]=dictdata[field]
  m.savemat(outn,cpdictdata)
  print outn



