#!/usr/bin/python
import time
import serial 
import string
from threading import Thread
import time
import numpy as np
import sys
import wx
import Queue
import random
import os
import datetime
import cPickle
import copy
import array
import socket
import commands
import matplotlib
import psychopy

sys.path.insert(0,os.getenv("HOME")+'/Copy/primatepy.eyetrack/primatepy/')

class bcolors:
  HEADER = '\033[95m'
  OKBLUE = '\033[94m'
  OKGREEN = '\033[92m'
  WARNING = '\033[93m'
  FAIL = '\033[91m'
  ENDC = '\033[0m'
  def disable(self):
    self.HEADER = ''
    self.OKBLUE = ''
    self.OKGREEN = ''
    self.WARNING = ''
    self.FAIL = ''
    self.ENDC = ''

print bcolors.ENDC+"-- Load local libraries ----------------"

DIR = os.path.dirname(os.path.realpath(__file__))+os.sep
lib_path = os.path.abspath(DIR)
sys.path.append(lib_path)

#lib_path = os.path.abspath('')
#sys.path.append(lib_path)
#lib_path = os.path.abspath('./eye')
#sys.path.append(lib_path)
print "gui"
from gui import gui
from gui import draw_wins
print "eye"
#from eye import read_viewPoint as viewpoint
#from eye import read_iView as iView
#from eye import TrackEye4_cv2 as IPS
from eye import read_ISCAN as iSCAN
from eye import read_IPS as IPS
from eye import eye_thread
from eye import eye
from gui import fix_windows as fw
print "inout"
from inout import inout
print "utils"
from utils import tcp 



print "-- Version Main libraries ----------------"
#print "Here are the version of the main python libraries"
print "Wx version\t\t: "+wx.__version__
print "Numpy version \t\t: "+np.__version__
print "Matplotlib version\t: "+matplotlib.__version__
print "Psychopy version\t: "+psychopy.__version__


if __name__ == '__main__':

  '''
  Creates the 5 windows necessary by default for calibration
  '''
  print "\t______________________________________\n"
  print "\t Welcome to PrimatePy - Olivier Joly\t"
  print "\t______________________________________\n"
  
  Quitb = Queue.Queue()
  idata = Queue.Queue()
  TCPDataQueue = Queue.Queue() # to be sent to stim PC for starting/stoping trial
  
  Windows=[]
  for i in range(0,5):
    Windows.append(fw.FixWindow(i,fw.defaultWinPos))

  fixpoint = dict()
  fixpoint['pts'] = [0,0]
  
  U3=[]
  try :
    import u3
    print 'DAQ/U3 seems to be installed'
  except :
    print bcolors.WARNING+'You must install U3 python package'+ bcolors.ENDC
  try :
    U3.append(u3.U3())
    print bcolors.OKGREEN+'DAQ/U3 Labjack was found'+ bcolors.ENDC
  except :
    print bcolors.FAIL+"No DAQ/U3 Labjack connected ?!"+ bcolors.ENDC
  print "-------------------------------------------------"
  TouchBar1 = inout.TouchBar(1)
  #Reward1 = inout.Reward(1)
  MR_TTL_pulse1 = inout.MR_TTL_pulse(1)    
  try:
    ser = serial.Serial()
  except :
    print bcolors.FAIL+"No serial port available"+bcolors.ENDC


  Maindict= {
  'ON':False,
  'subject':'',
  'RewardManual':50,
  'SaccadeDelay':280,
  'Scale XY':[1, 1],
  'Offset XY':[0, 0],
  'fixpoint':fixpoint,
  'targetindex':0,
  'targetpos':[0,0],
  'targetsize':7,
  'targetcontrast':0.4,
  'ListofWindows':Windows,
  'record_eye':False,
  'save_eye':False,
  'clear_eye':False,
  'indexWin':array.array('H'),
  'touchbarstatus':TouchBar1.status,
  'touchbarcouter':TouchBar1.counter,
  'QuitTCP':False,
  'TotalRWD':0,
  'HoldTime':1900,
  'RWD_trial':30,
  'RightEye':False,
  'ITTime':100,
  'targetcolor':(1,0,0),
  'bgcolor':(0,0,0),
  'maxRT':900,
  'contrast':0.8,
  'volA':100.0,
  'vol':40.0,
  'pcHold':45,
  'penaltytime':2000,
  'PCcatchtrials':40,
  'MRTTLpulsestatus':MR_TTL_pulse1.status,
  'MRTTLpulsecounter':MR_TTL_pulse1.counter,
  'runduration':600*10,
  'breakduration':60*1,
  }

  ''' 
  Here a series of Thread will be lauched with a possible exception and printed error.
  This multithreading approach allows to modify some parameters of the behavior through a GUI.
  We can read eye movements (e.g serial port) and the touchbar status (e.g Labjack) as fast as possible while writing a reward whenever 
  the task is sending the 'reward' command'''
  #for the moment no touchbar in use at the scanner
  #try:
    #ThTouchBar = CheckTouchBar(TouchBar1,U3,Quitb,Maindict)
    #ThTouchBar.start()
  #except:
    #print "Error : Unable to start Toucbar Thread"
  try:
    ThTouchBar = inout.CheckTouchBar(TouchBar1,U3,Quitb,Maindict)
    ThTouchBar.start()
    print bcolors.OKGREEN+"Starting Touch Bar:  OK"+bcolors.ENDC
  except:
    print bcolors.FAIL+ "Error : Unable to start Toucbar Thread"+bcolors.ENDC
      
  try:
    Th_Check_MR_TTL_pulse = inout.Check_MR_TTL_pulse(MR_TTL_pulse1,U3,Quitb,Maindict)
    Th_Check_MR_TTL_pulse.start()
    print bcolors.OKGREEN+"Starting Listen MR-TTL pulse:  OK"+bcolors.ENDC
  except:
    print bcolors.FAIL+"Error : Unable to start Check_MR_TTL_pulse Thread"+bcolors.ENDC
    
  try:
    ThRW = inout.WriteReward(U3,Quitb,Maindict) # just for testing with the bar to reward work perfectly !!
    ThRW.start()
    print bcolors.OKGREEN+"Starting Write Reward/TCP server:  OK"+bcolors.ENDC
  except:
    print bcolors.FAIL+"Error : Unable to start Write Reward/TCP server"+bcolors.ENDC

  try:
    Eyethread = eye.CheckEye(idata,Quitb,Maindict)
    Eyethread.start()
  except:
    print bcolors.FAIL+"Error: unable to start CheckEye Thread"+bcolors.ENDC

  try:
      UI = gui.GUI(Quitb,Maindict)
      UI.start()
  except:
    print bcolors.FAIL+"Error : Unable to start Main GUI"+bcolors.ENDC

  runRVP = False
  runRiView = False # put to True For Newcastle scanner !
  runiSCAN = False
  gen_eye =  False
  runIPS = True
  #runRVP= False

  for line in commands.getoutput("/sbin/ifconfig").split("\n"):
    sl = line.split()
    for item in sl:
      if item=='addr:10.10.10.1':
	IP='10.10.10.1'
	print 'It seems you are connected to iView'
	#runRiView = True # Useful line in Newcastle 
      elif item[0:8]=='addr:10.':
	IP=item[5:]
	print 'Current IP is %s ' % IP
      elif item[0:4]=='addr' and len(item)>5:
	print 'Current IP is %s ' % item

  
  if runRVP:
    try:
      t = viewpoint.readVP(ser,idata,Quitb)
      t.start()
    except:
      print bcolors.FAIL+"Error: unable to start ReadViewPoint"+bcolors.ENDC
      gen_eye = True
  elif runRiView:
    try:
      thriView = iView.read_iView(idata, Quitb)
      thriView.start() 
    except:
      print bcolors.FAIL+"Error: unable to start iView"+bcolors.ENDC
      gen_eye = True
  elif runiSCAN:
    try:
      thriScan= iSCAN.read_ISCAN(ser,idata, Quitb)
      thriScan.start() 
      print bcolors.OKGREEN+"starting ISCAN Reader"+bcolors.ENDC
    except:
      print bcolors.FAIL+"Error: unable to read ISCAN data/ Please check your serial-DB9/USB cable"+bcolors.ENDC
      gen_eye = True
  elif runIPS:
    try:
      t = IPS.read_IPS(idata,Quitb)
      t.start()
      print bcolors.OKGREEN+"starting IPS Reader"+bcolors.ENDC
    except:
      print bcolors.FAIL+"Error: unable to read IPS data/ Please check your USB PS3"+bcolors.ENDC
      gen_eye = True

  if gen_eye:  
    try:
      thr2 = eye_thread.eyeTh(idata, Quitb)
      thr2.start()
      print bcolors.OKGREEN+"starting ramdom eye generator"+bcolors.ENDC
    except:
      print bcolors.FAIL+"Error: unable to start ramdom eye generator"+bcolors.ENDC
    
  try:
      thr3 = draw_wins.ISCANWIN(Quitb,Maindict,TouchBar1,MR_TTL_pulse1)
      thr3.start()
  except:
      print bcolors.FAIL+"Error : Unable to start Control Window"+bcolors.ENDC

  try:
    server = tcp.serveronBehavPC(Maindict,Quitb)
    server.start()
    print bcolors.OKGREEN+"Starting server TCP Process...."+bcolors.ENDC
  except:
    print bcolors.FAIL+"Error : Unable to start server TCP Process"+bcolors.ENDC

  print "--"