import socket
#import serial
#import string
from threading import Thread
import Queue
#import binascii
import time
#import datetime
#import time
'''
The following code is useful to set an Ethernet connection between a python client (your PC) and the server (Eye tracker PC)
This way you are able to get the eye data in real-time. 
Last Update 13 October 2014
Olivier Joly, Oxford, UK
Email : olivier . j . joly at gmail [dot] com
'''

# General defintions 

eyedata = Queue.Queue()
disconnect = Queue.Queue()

class read_IPS(Thread):
  '''
  This is a Python Class : it is very useful to interface with Eye tracker
  Olivier Joly, Oxford, Last Updated 13 october 2014.
  Email : olivier . j . joly at gmail [dot] com
  '''
  def __init__(self,eyedata,disconnect):
      Thread.__init__(self)
      IP='localhost'
      PORT = 6012
      self.buffsize = 1024
      self.client_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
      self.client_socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
      self.client_socket.connect((IP, PORT))
      self.disconnect = disconnect
      self.eyedata = eyedata
  def run(self):
    t0 = time.time()
    while (self.disconnect.empty()):
      #data = self.client_socket.recv(self.buffsize)
      self.client_socket.send(time.ctime())
      data = self.client_socket.recv(self.buffsize)
      #data = cPickle.loads(client_socket.recv(buffsize))
      #print data
      #print time.time()-t0
      if self.eyedata.empty():
	datastrings = data.split()
	#print 'Refresh Rate : %fHz' % (1./(time.time()-t0))
	#print 'time: %f, X: %f, Y: %f,  delta: %d ms, pupil_x: %d, pupil_y: %d, ct: %d minute, index: %d' % (time.time() - t0, x,y,delta,pupil_x,pupil_y,ct,index)
	t0 = time.time()
	self.eyedata.put([float(datastrings[0]),float(datastrings[1]),float(datastrings[2])])
    #message = "ET_FRM %TS: %GX,%GY"
    #closing_message = message+"\n\r\n"
    #sock.sendto( entire_message, (self.IP_iView, self.port_iView) )
    print "Quit readIPS Connection"




