import wx
import os
import numpy
import string
import cPickle
import datetime
import floatSpin as FS
import fix_windows as fw
import sys
from eye import eye_calib as ical
from utils import utils
from threading import Thread
import wx.html

colorBG2="#6193EB"

ID_EXIT  = 102

def findall( L, start=0):
        # generator version
        T=list()
        for i in range(start, len(L)):
            try:
                T.append(int(L[i]))
            except ValueError:
                pass
        return T

def num2str(arrayNum):   
        stringfromarray = string.splitfields(str(arrayNum)[1:-1])
        stringfromarray=string.joinfields(stringfromarray,',')
        return stringfromarray
def getpass():
    dialog = wx.PasswordEntryDialog(None, 'Enter FTP (brainsenses) password')
    if dialog.ShowModal() == wx.ID_OK:
        value = dialog.GetValue()
    else:
        value = None
    dialog.Destroy()
    return value        

DIR = os.path.dirname(os.path.realpath(__file__))+os.sep
fileico = os.path.join(DIR,'ico.png')
aboutText = """<center><p><b>PrimatePy</b><br>
Version 1.0<br>
<br>
<img src=\""""+fileico+"""\" alt="PrimatePy" />
<br><br>
It is running on <b>wxPython</b> (%(wxpy)s) and <b>Python</b> (%(python)s).<br> <br>
<a href="http://brainsenses.x10host.com">http://brainsenses.x10host.com</a> <br><br>
Licence : GNU licence<br>
Copyright &copy 2012 Olivier Joly</p></center>""" 
class AboutBox(wx.Dialog):
    def __init__(self):
        wx.Dialog.__init__(self, None, -1, "About PrimatePy",
            style=wx.DEFAULT_DIALOG_STYLE|wx.THICK_FRAME|wx.RESIZE_BORDER|
                wx.TAB_TRAVERSAL)
        #self.SetBackgroundColour(colorBG2)        
        hwin = HtmlWindow(self, -1, size=(400,200))
        vers = {}
        vers["python"] = sys.version.split()[0]
        vers["wxpy"] = wx.VERSION_STRING
        hwin.SetPage(aboutText % vers)
        btn = hwin.FindWindowById(wx.ID_OK)
        irep = hwin.GetInternalRepresentation()
        hwin.SetSize((irep.GetWidth()+25, irep.GetHeight()+10))
        hwin.SetBackgroundColour(colorBG2)
        self.SetClientSize(hwin.GetSize())
        self.CentreOnParent(wx.BOTH)
        self.SetFocus()	
        
class HtmlWindow(wx.html.HtmlWindow):
    def __init__(self, parent, id, size=(600,400)):
        wx.html.HtmlWindow.__init__(self,parent, id, size=size)
        if "gtk2" in wx.PlatformInfo:
            self.SetStandardFonts()

    def OnLinkClicked(self, link):
        wx.LaunchDefaultBrowser(link.GetHref())	        
class MyNotebook(wx.Notebook):
    ### For this demo, we don't need to subclass
    ### Notebook at all.
    def __init__(self,parent,Maindict):
        wx.Notebook.__init__(self,parent=parent)
	p1 = BehavPanel(self,Maindict)
	p2 = StimPanel(self,Maindict)
	p3 = UtilsPanel(self)
        self.AddPage(p1, "Behaviour")
	self.AddPage(p2, "Stimuli")
	self.AddPage(p3, "Utils")
	
class MyFrame(wx.Frame):
    def __init__(self,parent,maindict):
	self.maindict = maindict 
	self.title = "PrimatePY - O. Joly"
        wx.Frame.__init__(self,parent=parent,title=self.title,pos=(0,0),size=(500,560))
        mbar = wx.MenuBar()
        self.Centre()
        self.Bind(wx.EVT_CLOSE, self.Goodbye)
        DIR = os.path.dirname(os.path.realpath(__file__))+os.sep
        fileico = os.path.join(DIR,'icoPrimatePy.ico')
        ico = wx.Icon(fileico, wx.BITMAP_TYPE_ICO)
        #ico = wx.Icon('cmtwhite.ico', wx.BITMAP_TYPE_ICO)
        self.SetIcon(ico)
        #self. Maximize() 
        self.SetMenuBar(mbar)
        #sbar = self.CreateStatusBar()
        self.Notebook = MyNotebook(self,maindict)
        ### Create a menu that allows user to select tabs as well
        ###  This uses ID values of 0 and 1 for the menu items.
        tabmenu = wx.Menu()
        tabmenu.AppendSeparator()
        #tabmenu.Append(wx.ID_OPEN,"&Open...\tCtrl+O","Load a Param. File")
        #self.Bind(wx.EVT_MENU,self.Open,id=wx.ID_OPEN)
        #tabmenu.Append(wx.ID_SAVE,"&Save\tCtrl+S","SAVE")
        #self.Bind(wx.EVT_MENU,self.Save,id=wx.ID_SAVE)
	#tabmenu.Append(wx.ID_SAVEAS,"&Save As...\t","SAVEAS")
        #self.Bind(wx.EVT_MENU,self.SaveAs,id=wx.ID_SAVEAS)
        #tabmenu.Append(wx.ID_PRINT,"&Print\tCtrl+P","Print Patient")
        #self.Bind(wx.EVT_MENU,self.Print,id=wx.ID_PRINT)
        tabmenu.Append(wx.ID_ABOUT, "&About\tCtrl+A", "Information about this program")
        self.Bind(wx.EVT_MENU, self.OnAbout,id=wx.ID_ABOUT)
        tabmenu.AppendSeparator()
        tabmenu.Append(wx.ID_CLOSE,"Close\tCtrl+X","Exit")
        self.Bind(wx.EVT_MENU,self.Goodbye,id=wx.ID_CLOSE)
        mbar.Append(tabmenu,"&File")
	self.count = 0
	self.currentfilename = None
	
    def Goodbye(self,evt):
	dlg = wx.MessageDialog(self, 
            "Do you really want to close PrimatePy?",
            "Confirm Exit", wx.OK|wx.CANCEL|wx.ICON_QUESTION)
        result = dlg.ShowModal()
        dlg.Destroy()
        if result == wx.ID_OK:
            self.Destroy()
        
    #def Print(self,evt):    
	##print 'To implement'
	#p=self.Notebook.GetSelection()
	#if self.currentfilename is None:
	  #self.SaveAs(wx.EVT_MENU)
	  #self.snapfilename = '%s-Quest%d%s' % (self.currentfilename.replace('.pkl','_'),p+1,'.png')
	#else:
	  #self.snapfilename = '%s-Quest%d%s' % (self.currentfilename.replace('.pkl','_'),p+1,'.png')
	#time.sleep(4)
	#save_window(self, self.snapfilename)
	#print 'Screenshot saved in %s' % self.snapfilename
	
    def Open(self,evt):
	if os.name=='posix':
	  self.dirname = os.getenv('HOME')
	else:
	  self.dirname = os.getenv('USERPROFILE')
        dlg = wx.FileDialog(self, "Choose a file", self.dirname, "", "*.pkl", wx.FD_OPEN)
        if dlg.ShowModal() == wx.ID_OK:
            self.filename = dlg.GetFilename()
            self.dirname = dlg.GetDirectory()
            self.filename = os.path.join(self.dirname, self.filename)
            self.SetTitle('%s - %s'% (self.title,self.filename))
            f = open(self.filename, 'r')
            allpatients = pkl.load(f)
            for p in range(self.Notebook.GetPageCount()-1):
	      page=self.Notebook.GetPage(p)
	      page.patient = allpatients[p]
	      page.OnLoad()
	      
    def Save(self,evt):
      allpatients = [] #list of patient data per Quest.
      for p in range(self.Notebook.GetPageCount()-1):
	page=self.Notebook.GetPage(p)
	page.OnUpdatePatient()
	#print page.patient
	allpatients.append(page.patient)
      if self.currentfilename is None:
	self.SaveAs(wx.EVT_MENU)
      else:
	FILE = open(self.currentfilename, 'w')
	pkl.dump(allpatients, FILE);FILE.close()
	print 'Data saved in file %s ' % self.currentfilename
	self.SetTitle('%s - %s'% (self.title,self.currentfilename))
	
	
    def SaveAs(self,evt):
      allpatients = [] #list of patient data per Quest.
      for p in range(self.Notebook.GetPageCount()-1):
	page=self.Notebook.GetPage(p)
	page.OnUpdatePatient()
	#print page.patient
	allpatients.append(page.patient)
      if os.name=='posix':
	datapath = os.getenv('HOME')
      else:
	datapath = os.getenv('USERPROFILE')
      a = datetime.datetime.now()
      #namefile = 'param_%s_%s_%d%02d%02d.pkl' % (allpatients[0]['protocolnb'],allpatients[0]['IDpatient'],a.year,a.month, a.day)
      def_value = namefile
      dlg = wx.FileDialog(self, "Enter a filename", datapath, def_value, "*.pkl", wx.FD_SAVE)
      if dlg.ShowModal() == wx.ID_OK:
	self.filename = dlg.GetFilename()
	self.dirname = dlg.GetDirectory()
	self.filename = os.path.join(datapath,self.filename)
	#self.currentfilename = self.filename
	if os.path.exists(self.filename):
	  mess= "%s already exist, Overwrite?" % self.filename
	  dlg = wx.MessageDialog(self, mess,"Confirm ", wx.OK|wx.CANCEL|wx.ICON_QUESTION)
	  result = dlg.ShowModal()
	  dlg.Destroy()
	  
	  if result == wx.ID_OK:
	    FILE = open(self.filename, 'w')
	    pkl.dump(allpatients, FILE);FILE.close()
	    print 'Data saved in file %s ' % self.filename
	    self.SetTitle('%s - %s'% (self.title,self.filename))
	    self.currentfilename = self.filename
	  #else result == wx.ID_OK:
	    #FILE = open(self.filename, 'w')
	    #pkl.dump(allpatients, FILE);FILE.close()
	    #print 'Data saved in file %s ' % self.filename
	    #self.SetTitle('%s - %s'% (self.title,self.filename))
	    #self.currentfilename = self.filename  
	else:
	  FILE = open(os.path.join(self.dirname, self.filename), 'w')
	  #print allpatients 
	  pkl.dump(allpatients, FILE);FILE.close()
	  print 'Data saved in file %s ' % self.filename
	  self.SetTitle('%s - %s'% (self.title,self.filename))
	  self.currentfilename = self.filename
      #else:
	#FILE = open(self.filename, 'w')
	#pkl.dump(allpatients, FILE);FILE.close()
	#print 'Data saved in file %s ' % self.filename
	#self.SetTitle('%s - %s'% (self.title,self.filename))
      
    def OnAbout(self, event):
        dlg = AboutBox()
        dlg.ShowModal()
        dlg.Destroy()
        
class GUI(Thread):
  def __init__(self,Quitb, Maindict):
    Thread.__init__(self)
    self.Maindict = Maindict
    self.Quitb = Quitb
  def run(self):
    #ID_EXIT=102
    while (self.Quitb.empty()) :
	self.app = wx.App(redirect=False)
	self.frame = MyFrame(None,self.Maindict)
	self.frame.Show()
	self.app.MainLoop()
    print "Quit main GUI"
    

    
class UtilsPanel(wx.Panel):
  def __init__(self, parent):
    wx.Panel.__init__(self, parent)
    self.Tar =wx.Button(self, label="Tar", pos=(100, 20))
    self.Bind(wx.EVT_BUTTON, self.OnTar,self.Tar)
    self.tarftp =wx.Button(self, label="Tar->FTP", pos=(100, 50))
    self.Bind(wx.EVT_BUTTON, self.OnTarFTP,self.tarftp )
    self.FTP =wx.Button(self, label="FTP", pos=(200, 20))
    self.Bind(wx.EVT_BUTTON, self.OnFTP ,self.FTP )
    self.untar =wx.Button(self, label="UnTar", pos=(300, 20))
    self.Bind(wx.EVT_BUTTON, self.OnunTar,self.untar )
    self.wgetuntar =wx.Button(self, label="FTP->UnTar", pos=(300, 50))
    self.Bind(wx.EVT_BUTTON, self.Onwgetuntar,self.wgetuntar)

    
  def OnTar(self,event):
    utils.tarsofts(datetime.datetime.now())
    
  def OnTarFTP(self,event):
    nfile = utils.tarsofts(datetime.datetime.now())
    password = getpass()
    utils.ftpbrainsenses(nfile,password)
    
  def Onwgetuntar(self,event):
    password = getpass()
    localtar = utils.getlastfromftp(datetime.datetime.now(),password)
    utils.untarsofts(localtar)
    
  def OnFTP(self,event):
    self.dirname = '/home/'+os.getlogin()+'/tmp'
    #self.dirname = ''
    dlg = wx.FileDialog(self, "Choose a file", self.dirname, "", "*.bz2", wx.OPEN)
    if dlg.ShowModal() == wx.ID_OK:
	self.filename = dlg.GetFilename()
	self.dirname = dlg.GetDirectory()
	password = getpass()
	utils.ftpbrainsenses(os.path.join(self.dirname, self.filename), password)
    dlg.Destroy()
    
  def OnunTar(self,event):
    self.dirname = '/home/'+os.getlogin()+'/Desktop/settings_stim'
    #self.dirname = ''
    dlg = wx.FileDialog(self, "Choose a file", self.dirname, "", "*.bz2", wx.OPEN)
    if dlg.ShowModal() == wx.ID_OK:
	self.filename = dlg.GetFilename()
	self.dirname = dlg.GetDirectory()
	utils.untarsofts(os.path.join(self.dirname, self.filename))
    dlg.Destroy()
    
    
class StimPanel(wx.Panel):
    def __init__(self, parent,Maindict):
        wx.Panel.__init__(self, parent)
#        self.logger = wx.TextCtrl(self, pos=(300,20), size=(200,300), style=wx.TE_MULTILINE | wx.TE_READONLY)
        self.buttonL =wx.Button(self, label="Load", pos=(20, 25))
        self.Bind(wx.EVT_BUTTON, self.OnOpen,self.buttonL)
        #self.Quitb = Quitb
        self.Maindict = Maindict
        self.dictlocal = dict()
        YP3=140
        step3=20
        #self.dict= {'fix_size': 4, 'fix_color': [1, -1, -1],'fix_pos':[0,0]}
        self.sendbutton =wx.Button(self, label="send", pos=(200, 20))
        self.Bind(wx.EVT_BUTTON, self.OnClicksend,self.sendbutton)
        #self.pos1button =wx.Button(self, label="1", pos=(220, 60),size=(45,23))
        #self.Bind(wx.EVT_BUTTON, self.Onpos1,self.pos1button)
	#self.pos2button =wx.Button(self, label="2", pos=(200, 40),size=(45,23))
        #self.Bind(wx.EVT_BUTTON, self.Onpos2,self.pos2button)
	#self.pos3button =wx.Button(self, label="3", pos=(240, 40),size=(45,23))
        #self.Bind(wx.EVT_BUTTON, self.Onpos3,self.pos3button)
	#self.pos4button =wx.Button(self, label="4", pos=(240, 80),size=(45,23))
        #self.Bind(wx.EVT_BUTTON, self.Onpos4,self.pos4button)
        #self.pos5button =wx.Button(self, label="5", pos=(200, 80),size=(45,23))
        #self.Bind(wx.EVT_BUTTON, self.Onpos5,self.pos5button)  
#        self.fixsize = wx.CheckBox(self, -1, 'Size', (10, YP3+step3))
        self.lblname = wx.StaticText(self, label="Size Fix Point.", pos=(10,YP3-2*step3))
        self.fixsize = wx.SpinCtrl(self, -1, 'Size Fix Point.',  (100, YP3-2*step3), (60, -1))
        self.fixsize.SetRange(0, 40)
        self.fixsize.SetValue(self.Maindict['targetsize'])
        
        self.lblname = wx.StaticText(self, label="HoldTime", pos=(20,YP3+5*step3))
        self.HoldTime = wx.SpinCtrl(self, -1, 'HoldTime',  (100, YP3+5*step3), (60, -1))
        self.HoldTime.SetRange(10, 10000)
        self.HoldTime.SetValue(self.Maindict['HoldTime'])
        
        self.lblname = wx.StaticText(self, label="+/- %", pos=(260,YP3+5*step3))
        self.pcHold= wx.SpinCtrl(self, -1, 'pcHold',  (200, YP3+5*step3), (60, -1))
        self.pcHold.SetRange(0, 99)
        self.pcHold.SetValue(self.Maindict['pcHold'])
        
        self.lblname = wx.StaticText(self, label="penaltytime", pos=(380,YP3+5*step3))
        self.penaltytime = wx.SpinCtrl(self, -1, 'penaltytime',  (300, YP3+5*step3), (60, -1))
        self.penaltytime.SetRange(10, 8000)
        self.penaltytime.SetValue(self.Maindict['penaltytime'])
        
        self.lblname = wx.StaticText(self, label="RWDtrial", pos=(20,YP3+7*step3))
        self.RWDtrial = wx.SpinCtrl(self, -1, 'RWDtrial',  (100, YP3+7*step3), (60, -1))
        self.RWDtrial.SetRange(10, 200)
        self.RWDtrial.SetValue(self.Maindict['RWD_trial'])
        
        self.lblname = wx.StaticText(self, label="Catch %", pos=(260,YP3+7*step3))
        self.PCcatchtrials = wx.SpinCtrl(self, -1, 'PCcatchtrials',  (200, YP3+7*step3), (60, -1))
        self.PCcatchtrials.SetRange(0, 100)
        self.PCcatchtrials.SetValue(self.Maindict['PCcatchtrials'])
        
        
        self.lblname = wx.StaticText(self, label="ITTime", pos=(20,YP3+9*step3))
        self.ITTime = wx.SpinCtrl(self, -1, 'ITTime',  (100, YP3+9*step3), (60, -1))
        self.ITTime.SetRange(50, 3000)
        self.ITTime.SetValue(self.Maindict['ITTime'])
        
        self.lblname = wx.StaticText(self, label="maxRT", pos=(20,YP3+11*step3))
        self.maxRT = wx.SpinCtrl(self, -1, 'maxRT',  (100, YP3+11*step3), (60, -1))
        self.maxRT.SetRange(100, 3000)
        self.maxRT.SetValue(self.Maindict['maxRT'])
        
        self.lblname = wx.StaticText(self, label="% volA", pos=(20,YP3+13*step3))
        self.volA = wx.SpinCtrl(self, -1, 'volA',  (100, YP3+13*step3), (60, -1))
        self.volA.SetRange(0, 100)
        self.volA.SetValue(self.Maindict['volA'])
        
        self.lblname = wx.StaticText(self, label="% vol", pos=(20,YP3+15*step3))
        self.vol = wx.SpinCtrl(self, -1, 'vol',  (100, YP3+15*step3), (60, -1))
        self.vol.SetRange(0, 100)
        self.vol.SetValue(self.Maindict['vol'])
        
        self.lblname = wx.StaticText(self, label="Run duration", pos=(260,YP3+13*step3))
        self.runduration = wx.SpinCtrl(self, -1, 'runduration',  (200, YP3+13*step3), (60, -1))
        self.runduration.SetRange(0, 9000)
        self.runduration.SetValue(self.Maindict['runduration'])
        
        self.lblname = wx.StaticText(self, label="Break duration", pos=(260,YP3+15*step3))
        self.breakduration = wx.SpinCtrl(self, -1, 'breakduration',  (200, YP3+15*step3), (60, -1))
        self.breakduration.SetRange(0, 900)
        self.breakduration.SetValue(self.Maindict['breakduration'])
        
        #self.lblname = wx.StaticText(self, label="% vol", pos=(20,YP3+15*step3))
        #self.vol = wx.SpinCtrl(self, -1, 'vol',  (100, YP3+15*step3), (60, -1))
        #self.vol.SetRange(0, 100)
        #self.vol.SetValue(self.Maindict['vol'])
        
        
        #self.cb1 = wx.CheckBox(self, -1, 'Red', (10, YP3+step3))
        #self.cb1.SetValue(self.Maindict['targetcolor'][0]==1)
        self.colorbutton =wx.Button(self, label="FixPointColor", pos=(10, YP3+step3))
        self.Bind(wx.EVT_BUTTON, self.onColorDlg,self.colorbutton)
        self.colorbutton2 =wx.Button(self, label="BackGrdColor", pos=(10, YP3+3*step3))
        self.Bind(wx.EVT_BUTTON, self.onColorDlg2,self.colorbutton2)
        #self.cb2 = wx.CheckBox(self, -1, 'Green', (10, YP3+2*step3))
        #self.cb2.SetValue(self.Maindict['targetcolor'][1]==1)
        #self.cb3 = wx.CheckBox(self, -1, 'Blue', (10, YP3+3*step3))
        #self.cb3.SetValue(self.Maindict['targetcolor'][2]==1)
        
        #self.TCPDataQueue=TCPDataQueue
    def onColorDlg(self, event):
        """
        This is mostly from the wxPython Demo!
        """
        dlg = wx.ColourDialog(self)
 
        # Ensure the full colour dialog is displayed, 
        # not the abbreviated version.
        dlg.GetColourData().SetChooseFull(True)
 
        if dlg.ShowModal() == wx.ID_OK:
            data = dlg.GetColourData()
            #print 'You selected: %s\n' % str(data.GetColour().Get())
            val = data.GetColour().Get()
	    self.Maindict['targetcolor'] = val
	    self.colorbutton.SetBackgroundColour(val)
        dlg.Destroy()

    def onColorDlg2(self, event):
        """
        This is mostly from the wxPython Demo!
        """
        dlg = wx.ColourDialog(self)
 
        # Ensure the full colour dialog is displayed, 
        # not the abbreviated version.
        dlg.GetColourData().SetChooseFull(True)
 
        if dlg.ShowModal() == wx.ID_OK:
            data = dlg.GetColourData()
            #print 'You selected: %s\n' % str(data.GetColour().Get())
            val = data.GetColour().Get()
	    self.Maindict['bgcolor'] = val
	    self.colorbutton2.SetBackgroundColour(val)
        dlg.Destroy()
        
    def OnClicksend(self,event):
        #if self.Quitb.empty() :
	self.Maindict['targetsize'] = self.fixsize.GetValue()
	self.dictlocal['targetsize'] = self.Maindict['targetsize']
	self.dictlocal['targetpos'] = self.Maindict['targetpos']
	self.dictlocal['targetcontrast'] = self.Maindict['targetcontrast']
	self.Maindict['HoldTime'] = self.HoldTime.GetValue()
	self.dictlocal['HoldTime'] = self.Maindict['HoldTime']
	self.Maindict['RWD_trial'] = self.RWDtrial.GetValue()
	self.dictlocal['RWD_trial'] = self.Maindict['RWD_trial']
	self.Maindict['ITTime'] = self.ITTime.GetValue()
	self.dictlocal['ITTime'] = self.Maindict['ITTime']
	#self.Maindict['targetcolor'] = (self.cb1.GetValue(),self.cb2.GetValue(),self.cb3.GetValue())
	self.dictlocal['targetcolor'] = self.Maindict['targetcolor']
	#self.Maindict['targetcolor'] = (self.cb1.GetValue(),self.cb2.GetValue(),self.cb3.GetValue())
	self.dictlocal['bgcolor'] = self.Maindict['bgcolor']
	self.Maindict['maxRT'] = self.maxRT.GetValue()
	self.dictlocal['maxRT'] = self.Maindict['maxRT']
	self.Maindict['volA'] = self.volA.GetValue()
	self.dictlocal['volA'] = self.Maindict['volA']
	self.Maindict['vol'] = self.vol.GetValue()
	self.dictlocal['vol'] = self.Maindict['vol']
	self.Maindict['pcHold'] = self.pcHold.GetValue()
	self.dictlocal['pcHold'] = self.Maindict['pcHold']
	self.Maindict['penaltytime'] = self.penaltytime.GetValue()
	self.dictlocal['penaltytime'] = self.Maindict['penaltytime']
	self.Maindict['PCcatchtrials'] = self.PCcatchtrials.GetValue()
	self.dictlocal['PCcatchtrials'] = self.Maindict['PCcatchtrials']
	self.Maindict['runduration'] = self.runduration.GetValue()
	self.dictlocal['runduration'] = self.Maindict['runduration']
	self.Maindict['breakduration'] = self.breakduration.GetValue()
	self.dictlocal['breakduration'] = self.Maindict['breakduration']	  
		
	a=datetime.datetime.now()
	setting_path = '/home/'+os.getlogin()+'/Desktop/settings_stim'
	namefile='%s_%d_%02d_%02d_%02d_%02d.pkl' % (self.Maindict['subject'],a.year,a.month, a.day, a.hour, a.minute)
	filename=os.path.join(setting_path,namefile)
	FILE = open(filename, 'w')
	print filename
	cPickle.dump(self.dictlocal, FILE)
	FILE.close()

    def OnOpen(self,e):
        """ Open a file"""
        self.dirname = '/home/'+os.getlogin()+'/Desktop/settings_stim'
        #self.dirname = ''
        filterfile = '%s*.pkl' % self.Maindict['subject']
        if not(self.Maindict['subject']==''):# if not empty subject
	  filterfile = '%s files (%s*.pkl)|%s*.pkl|All pkl (*.pkl)|*.pkl' % (self.Maindict['subject'],self.Maindict['subject'],self.Maindict['subject'])
        dlg = wx.FileDialog(self, "Choose a file", self.dirname, "", filterfile, wx.OPEN)
        if dlg.ShowModal() == wx.ID_OK:
            self.filename = dlg.GetFilename()
            self.dirname = dlg.GetDirectory()
            fileid = open(os.path.join(self.dirname, self.filename), 'r')
            #self.control.SetValue(f.read())
            self.localdict = cPickle.load(fileid)
            for f in self.localdict:
	      self.Maindict[f] = self.localdict[f]
            #self.cb1.SetValue(self.localdict['fix_color'][0]==1)
            #self.cb2.SetValue(self.dict['fix_color'][1]==1);
            #self.cb3.SetValue(self.localdict['fix_color'][2]==1)
            self.fixsize.SetValue(self.Maindict['targetsize'])
	    self.HoldTime.SetValue(self.Maindict['HoldTime'])
	    self.RWDtrial.SetValue(self.Maindict['RWD_trial'])
	    self.ITTime.SetValue(self.Maindict['ITTime'])
	    #self.cb1.SetValue(self.Maindict['targetcolor'][0])
	    #self.cb2.SetValue(self.Maindict['targetcolor'][1])
	    #self.cb3.SetValue(self.Maindict['targetcolor'][2])
	    self.maxRT.SetValue(self.Maindict['maxRT'])
	    self.pcHold.SetValue(self.Maindict['pcHold'])
	    self.volA.SetValue(self.Maindict['volA'])
	    self.vol.SetValue(self.Maindict['vol'])
	    self.penaltytime.SetValue(self.Maindict['penaltytime'])
	    self.PCcatchtrials.SetValue(self.Maindict['PCcatchtrials'])
            self.fixsize.SetValue(self.localdict['targetsize'])
            print os.path.join(self.dirname, self.filename)
            fileid.close()
        dlg.Destroy()


class BehavPanel(wx.Panel):
    def __init__(self, parent, Maindict):
        #self.frame = frame
        #self.Quitb = Quitb
        self.Maindict = Maindict
        wx.Panel.__init__(self, parent)

        self.sampleList = ['Ranger', 'Seb','Stevie', 'Scott']
       
        self.buttonL = wx.Button(self, label="Load Conf.", pos=(10, 35))
        self.Bind(wx.EVT_BUTTON, self.OnOpen,self.buttonL)        
        
        self.ONOFF = wx.Button(self, label="ON", pos=(140, 3),size=(45,23))  # Olivier 03/09/2010
        self.Bind(wx.EVT_BUTTON, self.OnSwitch,self.ONOFF) # Olivier 03/09/2010
        self.statecolor=self.ONOFF.GetBackgroundColour() # Olivier 03/09/2010
        self.statecolor.SetFromName('Green') # Olivier 03/09/2010
	self.ONOFF.SetBackgroundColour(self.statecolor) # Olivier 03/09/2010
	self.status=0
	YP2=160
        YP3=180
        step3=20
        self.lblhear = wx.StaticText(self, label="Monkey:", pos=(20, YP2))
        self.edithear = wx.ComboBox(self, pos=(80, YP2), size=(95, -1), choices=self.sampleList,style=wx.TE_PROCESS_ENTER)
        self.Bind(wx.EVT_COMBOBOX, self.EvtComboBox, self.edithear)
        
        wx.StaticLine(self, -1, (10, YP3+20), (450,1))
        
        self.buttonCalib =wx.Button(self, label="Calib. File", pos=(400, YP3+3*step3-10))
        self.Bind(wx.EVT_BUTTON, self.OnOpenCalib,self.buttonCalib)

        self.resetCalib = wx.Button(self, label="reset calib", pos=(400,YP3+8*step3+10))
        self.Bind(wx.EVT_BUTTON, self.OnresetCalib,self.resetCalib)
        
        self.cb1 = wx.CheckBox(self, -1, 'RightEye', (10, YP3+2*step3))
        self.cb1.SetValue(self.Maindict['RightEye'])
        #self.cb2 = wx.CheckBox(self, -1, 'Eye-Y', (10, YP3+2*step3))
        #self.cb2.SetValue(self.Maindict['Eye'][1])
	shifttext = 10
        wx.StaticText(self, label="Scale X", pos=(40-shifttext,YP3+5*step3))
        self.scale_x= FS.FloatSpin(self, -1, min_val=0, max_val=100,increment=0.01, extrastyle=FS.FS_RIGHT, pos=(90-shifttext, YP3+5*step3))
        self.scale_x.SetFormat("%f")
        self.scale_x.SetDigits(2)
        self.scale_x.SetValue(self.Maindict['Scale XY'][0])
        wx.StaticText(self, label="Scale Y", pos=(40-shifttext,YP3+7*step3))
        self.scale_y= FS.FloatSpin(self, -1, min_val=0, max_val=100,increment=0.01, extrastyle=FS.FS_RIGHT, pos=(90-shifttext, YP3+7*step3))
        self.scale_y.SetFormat("%f")
        self.scale_y.SetDigits(2)
        rangeoffset = 4000
        self.scale_y.SetValue(self.Maindict['Scale XY'][1])
        
        wx.StaticText(self, label="Off. X:", pos=(200-shifttext,YP3+5*step3))
        self.sldX = wx.Slider(self, -1, 0, -rangeoffset, rangeoffset, size=(200+2*shifttext, -1), style=wx.SL_AUTOTICKS | wx.SL_HORIZONTAL | wx.SL_LABELS, pos=(260-shifttext,YP3+4*step3))
        wx.StaticText(self, label="Off. Y:", pos=(200-shifttext,YP3+7*step3))
        self.sldY = wx.Slider(self, -1, 0, -rangeoffset, rangeoffset, size=(200+2*shifttext, -1), style=wx.SL_AUTOTICKS | wx.SL_HORIZONTAL | wx.SL_LABELS, pos=(260-shifttext,YP3+6*step3))
       
        wx.StaticLine(self, -1, (10, YP3+10*step3), (450,1))
        
        self.RAbutton =wx.Button(self, label="Send", pos=(100, 35)) # Button to send and save parameters of the GUI
        self.Bind(wx.EVT_BUTTON, self.OnClickRA,self.RAbutton)
        
        self.Eye1button =wx.Button(self, label="Record Eye", pos=(200, 35)) # Button to record eye movement
        self.Bind(wx.EVT_BUTTON, self.OnClickEye1,self.Eye1button)
        self.Eye1button.SetBackgroundColour('White')
        
        self.Eye2button =wx.Button(self, label="Save Eye", pos=(300, 35)) # Button to record eye movement
        self.Bind(wx.EVT_BUTTON, self.OnClickEye2,self.Eye2button)
        
        self.Eye3button =wx.Button(self, label="Clear Eye", pos=(400, 35)) # Button to record eye movement
        self.Bind(wx.EVT_BUTTON, self.OnClickEye3,self.Eye3button)
        
        self.Winbutton =wx.Button(self, label="AddWin", pos=(200, 75)) # Button to Add a window
        self.Bind(wx.EVT_BUTTON, self.OnClickAddWins,self.Winbutton)  
        
        self.WinMinusbutton =wx.Button(self, label="RemWin", pos=(300, 75)) # Button to Remove a window
        self.Bind(wx.EVT_BUTTON, self.OnClickMinWins,self.WinMinusbutton)
        
        self.lblname = wx.StaticText(self, label="Saccade delay", pos=(10,YP3+11*step3))
        self.sc = wx.SpinCtrl(self, -1, 'Saccade delay',  (120, YP3+11*step3), (60, -1))
        self.sc.SetRange(0, 1000)
        self.sc.SetValue(self.Maindict['SaccadeDelay'])
        
        self.lblname = wx.StaticText(self, label="Reward Man.", pos=(14,YP3+13*step3))
        self.rwm = wx.SpinCtrl(self, -1, 'Reward Man.',  (120, YP3+13*step3), (60, -1))
        self.rwm.SetRange(10, 500)
        self.rwm.SetValue(self.Maindict['RewardManual'])
        
        #self.button =wx.Button(self, label="Quit", pos=(200, YP3+15*step3))
        #self.Bind(wx.EVT_BUTTON, self.OnClick,self.button)
        
    def EvtComboBox(self, event):
        monkeyname=event.GetString()
        self.Maindict['subject']='%s' % monkeyname
        
    #def OnClick(self,event):
        #self.Quitb.put(True)
        #self.frame.Close()
        
    def OnClickEye1(self, event):
        if not(self.Maindict['record_eye']):
	  self.Maindict['record_eye']= True
          print 'Start Recording of eye data'
          self.Eye1button.SetBackgroundColour('Red')
        else :
	  self.Maindict['record_eye']= False
          print 'Stop Recording of eye data'
          self.Eye1button.SetBackgroundColour('White')
          
    def OnClickEye2(self, event):
        self.Maindict['save_eye'] = True
        print 'Saving eye data'

          
    def OnClickEye3(self, event):
        self.Maindict['clear_eye'] = True
        print 'Clear eye data'
                 
    def OnClickAddWins(self, event):
        if len(self.Maindict['ListofWindows']) < fw.defaultWinPos.shape[0]:
	  self.Maindict['ListofWindows'].append(fw.FixWindow(len(self.Maindict['ListofWindows']),fw.defaultWinPos))
          print 'Add a Window # %s ' % len(self.Maindict['ListofWindows'])
          
    def OnClickMinWins(self, event):
      if len(self.Maindict['ListofWindows']) > 1:
	self.Maindict['ListofWindows'].pop()
	print 'Remove Window # %s' % len(self.Maindict['ListofWindows'])
	
    def OnClickRA(self,event):
        #if self.Quitb.empty() :
	  self.Maindict['SaccadeDelay'] = self.sc.GetValue()
	  self.Maindict['RewardManual'] = self.rwm.GetValue()
	  #self.Maindict['Eye']=[self.cb1.GetValue() ,self.cb2.GetValue()]
	  self.Maindict['RightEye'] = self.cb1.GetValue() 
	  self.Maindict['Scale XY'] = [float(self.scale_x.GetValue()), float(self.scale_y.GetValue()) ]
	  self.Maindict['Offset XY']= [self.sldX.GetValue(), self.sldY.GetValue() ]

	  setting_path = '/home/'+os.getlogin()+'/Desktop/settings_behaviour'
	  if not(os.path.exists(setting_path)):
	      os.mkdir(setting_path)
#            setting_path='/home/olivier/Desktop/settings_behaviour'
	  a=datetime.datetime.now()
	  namefile='%s_%d_%02d_%02d_%02d_%02d.pkl' % (self.Maindict['subject'],a.year,a.month, a.day, a.hour, a.minute)
	  filename=os.path.join(setting_path,namefile)
	  FILE = open(filename, 'w')
	  print self.Maindict 
	  cPickle.dump(self.Maindict, FILE)
	  FILE.close()
	  print 'parameters saved in file %s ' % filename
    #def OnClickRA(self,event):
      
    def EvtRA(self, event):
        t=event.GetString()
        ST=string.split(t,',')
        STN=findall(ST)
        val=numpy.asarray(STN,dtype=int)
        self.RA=val

 

    def EvtRD(self, event):
        t=event.GetString()
        ST=string.split(t,',')
        STN=findall(ST)
        val=numpy.asarray(STN,dtype=int)
        self.RD=val
    
    def EvtRrT(self, event):
        t=event.GetString()
        ST=string.split(t,',')
        STN=findall(ST)
        val=numpy.asarray(STN,dtype=int)
        self.RrT=val    
        
    def EvtRiter(self, event):
        t=event.GetString()
        ST=string.split(t,',')
        STN=findall(ST)
        val=numpy.asarray(STN,dtype=int)
        self.Riter=val  
        
    def EvtChar(self, event):
        event.Skip()
        
    def OnOpenCalibOld(self,e):
      self.dirname = '/home/'+os.getlogin()+'/Desktop/data_behaviour'
      dlg = wx.FileDialog(self, "Choose a file", self.dirname, "", "*_calib.txt", wx.OPEN)
      if dlg.ShowModal() == wx.ID_OK:
	  self.filename = dlg.GetFilename()
	  self.dirname = dlg.GetDirectory()
	  f = open(os.path.join(self.dirname, self.filename), 'r')
	  a=f.readline()
	  dict=self.Maindict
	  exec(a)
	  self.Maindict=dict
	  self.scale_x.SetValue(self.Maindict['Scale XY'][0])
          self.scale_y.SetValue(self.Maindict['Scale XY'][1])
          self.sldX.SetValue(self.Maindict['Offset XY'][0])
          self.sldY.SetValue(self.Maindict['Offset XY'][1])
          f.close()
          print self.Maindict
          dlg.Destroy()
          
    def OnOpenCalib(self,e):
      self.dirname = '/home/'+os.getlogin()+'/Desktop/data_behaviour'
      dlg = wx.FileDialog(self, "Choose a file", self.dirname, "", "eye*.pkl", wx.OPEN)
      if dlg.ShowModal() == wx.ID_OK:
	  self.filename = dlg.GetFilename()
	  self.dirname = dlg.GetDirectory()
	  fullfilename = os.path.join(self.dirname, self.filename)
	  localdict = ical.calibrationInter(fullfilename)
	  self.Maindict['Scale XY'] = localdict['Scale XY']
	  self.Maindict['Offset XY'] = localdict['Offset XY']
	  self.scale_x.SetValue(self.Maindict['Scale XY'][0])
          self.scale_y.SetValue(self.Maindict['Scale XY'][1])
          self.sldX.SetValue(self.Maindict['Offset XY'][0])
          self.sldY.SetValue(self.Maindict['Offset XY'][1])
          print self.Maindict
          dlg.Destroy()
          
    def OnresetCalib(self,event):
      self.Maindict['Scale XY'] = [1,1] 
      self.Maindict['Offset XY'] =  [0,0]
      self.scale_x.SetValue(self.Maindict['Scale XY'][0])
      self.scale_y.SetValue(self.Maindict['Scale XY'][1])
      self.sldX.SetValue(self.Maindict['Offset XY'][0])
      self.sldY.SetValue(self.Maindict['Offset XY'][1])
      
    def OnSwitch(self,event): # Olivier 03/09/2010
      if self.ONOFF.GetLabel()=='ON':
	print 'Switch ON the task'
	self.status=1
	#self.Maindict['Reward'] = self.status*self.RA
	self.Maindict['ON'] = True
	#self.Qdict.put(self.Maindict)
	self.ONOFF.SetLabel('OFF')
	self.statecolor.SetFromName('Red')
	self.ONOFF.SetBackgroundColour(self.statecolor)	
      else :
	print 'Switch OFF the task'
	#self.quitnmr.put('Quit')
	self.ONOFF.SetLabel('ON')
	self.Maindict['ON'] = False
	#self.TCPDataQueue.put("pulse=0")
	self.status=0
	#self.dict2['Reward']=0*self.RA
	#self.Maindict['Reward']=self.status*self.RA
	#self.Qdict.put(self.dict)
        #self.Qdict2.put(self.dict2)
	self.statecolor.SetFromName('Green')
	self.ONOFF.SetBackgroundColour(self.statecolor)
	
	
    def OnOpen(self,e):
        """ Open a file"""
        self.dirname = '/home/'+os.getlogin()+'/Desktop/settings_behaviour'
        dlg = wx.FileDialog(self, "Choose a file", self.dirname, "", "*.pkl", wx.OPEN)
        if dlg.ShowModal() == wx.ID_OK:
            self.filename = dlg.GetFilename()
            self.dirname = dlg.GetDirectory()
            f = open(os.path.join(self.dirname, self.filename), 'r')
            #self.control.SetValue(f.read())
            self.Maindict = cPickle.load(f)
            self.sc.SetValue(self.Maindict['SaccadeDelay'])
            self.rwm.SetValue(self.Maindict['RewardManual'])
            self.scale_x.SetValue(self.Maindict['Scale XY'][0])
            self.scale_y.SetValue(self.Maindict['Scale XY'][1])
            self.sldX.SetValue(self.Maindict['Offset XY'][0])
            self.sldY.SetValue(self.Maindict['Offset XY'][1])
            #self.RAeditname.SetValue(num2str(self.Maindict['Reward']))
            #self.RDeditval.SetValue(num2str(self.Maindict['Delay']))
            #self.RrTeditval.SetValue(num2str(self.Maindict['randTime']))
            #self.Ritereditval.SetValue(num2str(self.Maindict['iterate']))
            print self.Maindict 
            print os.path.join(self.dirname, self.filename)
            f.close()
            dlg.Destroy()

