#from . import soundprimpy as sp
import numpy as np
from psychopy import sound
from matplotlib import pyplot as pl

def AM(duration=1.0):
  sf = 44100.0                        # sample frequency (Hz)
  #d = 1.0;                           # duration (s)
  n = sf * np.float(duration)         # number of samples
  #% set carrier
  cf = 750                         # carrier frequency (Hz)
  c = np.arange(1,n) / sf                    # carrier data preparation
  c = np.sin(2 * np.pi * cf * c)          # sinusoidal modulation
  #% set modulator
  mf = 3                            # modulator frequency (Hz)
  mi = 0.5                         # modulator index
  m = np.arange(1,n) / sf                    # modulator data preparation
  m = 1 + mi * np.sin(2 * np.pi * mf * m) # sinusoidal modulation
  #% amplitude modulation
  s = m * c                        # amplitude modulation
  soundA = sound.SoundPygame(s,sampleRate=np.int(sf),bits=16)
  return (soundA,s)