import numpy as np
import scipy.signal as s

def pinknoise():
  Nx = np.power(2,16) # number of samples to synthesize
  A = [1, -2.494956002,   2.017265875,  -0.522189400]
  B = [0.049922035, -0.095993537, 0.050612699, -0.004408786]
  nT60 = np.round(np.log(1000)/(1-np.max(np.abs(np.roots(A))))) # T60 est. the time to decay by  60 dB
  v = np.random.randn(1,int(Nx+nT60)) # Gaussian white noise: N(0,1)
  x = s.lfilter(B,A,v[0])  # Apply 1/F roll-off to PSD
  x = x[nT60+1:end] # Skip transient response
  return x