import numpy as np
import scipy as sc
import scipy.signal
import struct 
import os
import cPickle as pkl
import scipy.io.wavfile as w
import time

#------------------------------------------------------------ basic functions  
def readbin(fname):
  ''' Read the .bin filter info files from Sensimetrics 
  '''
  fid = open(fname, 'r')
  f_data = []
  while True: 
    try:dd = fid.read(8);f_data.append(struct.unpack('d',dd))
    except:break;
  fid.close()
  return np.squeeze(np.asarray(f_data))

#------------------------------------------------------------ end basic functions  

def convertbintopkl():
  ''' This function converts the .bin for left and right into a single pickle binary file with both 44.1 and 22 kHz values
  '''
  fL = 'EQF_203L.bin' # name of left filter impulse  response function
  fR = 'EQF_203R.bin' # name of right filter impulse  response function
  # read the .bin files :
  f_L44 = readbin(fL) 
  f_R44 = readbin(fR)
  f_L22 = sc.signal.resample(f_L44,len(f_L44)/2) #
  f_R22 = sc.signal.resample(f_R44,len(f_R44)/2) #
  EQFF_IR_203 = dict()
  EQFF_IR_203 = {'L44':f_L44,'R44':f_R44,'L22':f_L22,'R22':f_R22}
  pkl.dump(EQFF_IR_203, open('EQF_203LR.pkl', 'wb'))


def apply_MR_EQF(soundinput,fs=44100,filterfile='EQF_203LR.pkl',ouputfname=None,prefix='fLR',fft=True):
  '''
  soundinput can be a wavfile or an numpy array (nsamples,nchannels, int16),
  !! Important !! : when using it with an array please specify the fs parameter if different than 44.1kHz 
  This function applies the sensimetrics filter by direct convolution or through FFT
  '''
  starttime = time.time()
  sampfreq = 44100 # sampling freq. of reference used for the impulse response function given by sensimetrics
  pkl_file = open(filterfile, 'rb') # assume the pickle file locally available otherwise change the path
  EQF_203 = pkl.load(pkl_file)
  if fft:
    method = 'fft'
  else:
    method = 'conv'
  # read the wave file:
  if isinstance('soundinput', str): # the soundinput is a wavfile
    if os.path.exists(soundinput):
      fs,data = w.read(soundinput)
  else: # the soundinput is an sound array
    data = soundinput    
  if len(data.shape)>1:# if stereo
    print 'File (%s) is Stereo' % soundinput
    datar = data[:,1]
    datal = data[:,0]
  else : # if mono
    print 'File (%s) is Mono' % soundinput
    datar=datal=data
  # Filter the data from the wave file by convolution with the impulse response function
  print 'File (%s) sampled at %d Hz' % (soundinput,fs)
  rlen=len(datar)
  llen=len(datal)
  start = 0
  if fs==sampfreq: # if 44.1kHz
    if fft: # if FFT method
      print 'Method : FFT'
      rdata = sc.signal.fftconvolve(datar,EQF_203['R44'])
      ldata = sc.signal.fftconvolve(datal,EQF_203['L44'])
    else: # if convolution method
      print 'Method : Convolution'
      rdata = sc.convolve(datar,EQF_203['R44'])
      ldata = sc.convolve(datal,EQF_203['L44'])
    start = np.floor((len(rdata)-len(datar))/2)
    rdata = rdata[start:len(rdata)-start]
    ldata = ldata[start:len(ldata)-start]
  else: # if not 44.1kHz 
    if fft: # if FFT method
      print 'Method : FFT'
      rdata = sc.signal.fftconvolve(sc.signal.resample(datar,np.round(rlen*sampfreq/fs)),EQF_203['R44'])
      ldata = sc.signal.fftconvolve(sc.signal.resample(datal,np.round(llen*sampfreq/fs)),EQF_203['L44'])
    else: # if convolution method
      print 'Method : Convolution'
      rdata = sc.convolve(sc.signal.resample(datar,np.round(rlen*sampfreq/fs)),EQF_203['R44'])
      ldata = sc.convolve(sc.signal.resample(datal,np.round(llen*sampfreq/fs)),EQF_203['L44'])
    start = np.floor((len(rdata)-np.round(rlen*sampfreq/fs))/2)
    rdata = rdata[start:len(rdata)-start]
    ldata = ldata[start:len(ldata)-start]
    rdata = sc.signal.resample(rdata,rlen);ldata = sc.signal.resample(rdata,llen)
  if ouputfname is None and isinstance('soundinput', str):
    ouputfname = os.path.join(os.path.dirname(os.path.abspath(soundinput)),'%s_%s_%s'%(prefix,method,os.path.basename(soundinput)))
    print 'Output : %s ' % ouputfname
  outdata = np.asarray([ldata.astype('int16'),rdata.astype('int16')]).T
  w.write(ouputfname,fs,outdata)
  print 'Elapsed time %f' % (time.time()-starttime)
  return outdata
  #return data,outdata


def testfilter():
  outdata = apply_MR_EQF('chris/WhiteNoiseSound22050.wav',fft=True)
  outdata = apply_MR_EQF('chris/WhiteNoiseSound22050.wav',fft=False)
  outdata = apply_MR_EQF('stereosineWithNoise44100.wav',fft=True)
  outdata = apply_MR_EQF('stereosineWithNoise44100.wav',fft=False)
  outdata = apply_MR_EQF(soundarray,fs=22050,fft=True)
  
#convertbintopkl()
#testfilter()
