import os
import socket
'''
Could be useful to get the ip of the PC and display in the Gui ...not yet into the GUI
'''
if os.name != "nt":
  import fcntl
  import struct
  def get_interface_ip(ifname):
      s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
      return socket.inet_ntoa(fcntl.ioctl(
		      s.fileno(),
		      0x8915,  # SIOCGIFADDR
		      struct.pack('256s', ifname[:15]))[20:24])



def get_lan_ip():
  '''
  This is function to retreive the IP adress from the computer
  '''
  ip = socket.gethostbyname(socket.gethostname())
  if ip.startswith("127.") and os.name != "nt":
    interfaces = ["eth0","eth1","eth2","wlan0","wlan1","wifi0","ath0","ath1","ppp0"]
    for ifname in interfaces:
      try:
	ip = get_interface_ip(ifname)
	break;
      except IOError:
	pass
  return ip