##########################################################################
#                                                                        #
#    copyright (c) 2004 Royal Belgian Institute for Natural Sciences     #
#                       and contributors                                 #
#                                                                        #
##########################################################################

""" MinimalBibrefStyle class
    a very minimal bibliography style
"""

# Zope stuff
from Globals import InitializeClass
from App.Dialogs import MessageDialog

# CMFBibliographyAT stuff
from Products.CMFBibliographyAT.config import REFERENCE_TYPES

# Bibliolist stuff
from base import BibrefStyle


class MinimalBibrefStyle(BibrefStyle):
    """ specific formatter to process input in minimal format
    """
    
    meta_type = "Minimal Bibref Style"
    
    def __init__(self, id = 'Minimal',
                 title = "Minimal bibliography reference style"):
        """ initializes only id and title
        """
        self.id = id
        self.title = title
        
    def formatDictionary(self, refValues):
        """ formats a bibref dictionnary
        """
        formatted_entry = ''
        uid = refValues.get('UID')
        
        entry_type = refValues.get('meta_type')
        if not entry_type:
            entry_type = str(refValues.get('ref_type'))+'Reference'
            
        if entry_type in REFERENCE_TYPES:
            #authors
            authors = refValues.get('authors')
            if authors == []:
                pass
            elif len(authors) == 1:
                formatted_entry += '%s ' % self.formatAuthor(authors[0])
            else:
                formatted_entry += '%s' % self.formatAuthor(authors[0])
                if len(authors[1:-1]):
                    for author in authors[1:-1]:
                        formatted_entry += ', %s' % self.formatAuthor(author)
                formatted_entry += ' and %s' % self.formatAuthor(authors[-1])
                formatted_entry += ' '
                
                # editor flag
            if refValues.get('editor_flag'):
                formatted_entry += ' (ed.)' 
                # publication year
            if refValues.get('publication_year'):
                formatted_entry += ' (%s):' % refValues.get('publication_year')
                
                # title
            title_link = refValues.get('title_link')
            title = refValues.get('title')
            if title and title[-1] not in '.!?': title += '.'
            if title_link:
                title = ' <a UID="%s" href="%s">%s</a>' % (uid, title_link, title)
            formatted_entry = formatted_entry + ' ' + title
            
            #source
            formatted_entry += ' - %s' % refValues.get('source')
            
        return formatted_entry
        
        # due to a misprint in former style versions this has to be here for compatibility
    formatDictionnary = formatDictionary
    
    def formatAuthor(self, author):
        """ """
        result = '%s %s %s' % (author.get('firstname'),
                               author.get('middlename'),
                               author.get('lastname'))
        url = author.get('homepage')
        if url:
            result = '<a href="%s">%s</a>' %(url, result)
        return result
        
        # Class instanciation
InitializeClass(MinimalBibrefStyle)


def manage_addMinimalBibrefStyle(self, REQUEST=None):
    """ """
    try:
        self._setObject('Minimal', MinimalBibrefStyle())
    except:
        return MessageDialog(
            title='BiblioList tool warning message',
            message='The bibref style you attempted to add already exists.',
            action='manage_main')
    return self.manage_main(self, REQUEST)
