# File: langstring.py
"""
VDEX compliant vocabulary langstring
"""
# Copyright (c) 2005 by eduplone Open Source Business Network EEIG
# This code was created for the ZUCCARO project.
# ZUCCARO (Zope-based Universally Configurable Classes for Academic Research
# Online) is a database framework for the Humanities developed by the
# Bibliotheca Hertziana, Max-Planck Institute for Art History
# For further information: http://zuccaro.biblhertz.it/
#
# BSD-like licence, see LICENCE.txt
#
__author__  = '''Jens Klein <jens@bluedynamics.com>'''
__docformat__ = 'plaintext'

from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
try:
    from Products.Archetypes.interfaces.vocabulary import IVocabularyTerm
except ImportError:
    from Products.ATVocabularyManager.backports import IVocabularyTerm    
from Products.ATVocabularyManager.utils import xml

class VdexLangstring(BaseContent):
    """ content type representing a VDEX compliant langstring """

    __implements__ = getattr(BaseFolder,'__implements__',()) + (IVocabularyTerm,)

    security = ClassSecurityInfo()
    portal_type = meta_type = 'VdexLangstring'
    archetype_name          = 'langstring'   #this name appears in the 'add' box
    global_allow            = False

    allow_discussion        = False
    #content_icon            = 'VdexLangstring.png'

    aliases = { 
        '(Default)' : 'base_view', 
        'view' : 'base_view', 
        'edit' : 'base_edit', 
    }

    def getDOMBindingNode(self,doc):
        """
        returns a dom-element containing itself and all it subobjects dom
        representation
        """
        node=doc.createElement('langstring')
        s = self.getId().split('.')
        lang = s[len(s)-1]
        if lang != 'default':
            xml.setAttr(doc,node,'language',lang)
        textnode=doc.createTextNode(self.Title())
        node.appendChild(textnode)
        return node

    def SearchableText(self):
        return ''


registerType(VdexLangstring)
