# File: VdexMediaDescriptor.py
"""\
VDEX Media-Descriptor

RCS-ID $Id: codesnippets.py 3417 2005-01-11 19:29:35Z yenzenz $
"""
# Copyright (c) 2005 by eduplone Open Source Business Network EEIG
# This code was created for the ZUCCARO project.
# ZUCCARO (Zope-based Universally Configurable Classes for Academic Research
# Online) is a database framework for the Humanities developed by the
# Bibliotheca Hertziana, Max-Planck Institute for Art History
# For further information: http://zuccaro.biblhertz.it/
#
# BSD-like licence, see LICENCE.txt
#
__author__  = '''Jens Klein <jens@bluedynamics.com>'''
__docformat__ = 'plaintext'

from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
from Products.ATVocabularyManager.types.vdex.schemata import mediadescriptor_schema as schema

class VdexMediaDescriptor(BaseFolder):
    """ content type representing a VDEX Media-Descriptor """

    __implements__ = getattr(BaseContent,'__implements__',())

    security = ClassSecurityInfo()
    portal_type = meta_type = 'VdexMediaDescriptor'
    archetype_name          = 'VdexMediaDescriptor'
    allowed_content_types   = ['VdexLangstring',]
    allow_discussion        = False
    immediate_view          = 'base_view'
    global_allow            = False
    filter_content_types    = True

    schema = schema

    aliases = { 
        '(Default)' : 'base_view', 
        'view' : 'base_view', 
        'edit' : 'base_edit', 
    }

    def Title(self):
        """ returns langstring of default language or first available """
        lang = 'default'
        try:
            langstring=self[lang].Title()
        except:
            langstring=None
        if not langstring:
            langstringids=self.objectIds()
            if langstringids:
                langstring=self[langstringids[0]].Title()
            else:
                langstring='(not available)'

        return langstring

    def setTitle(self,title,lang=None):
        """ set title as langstring """
        lang = lang or 'default'
        if not lang in self.contentIds():
            self.invokeFactory('VdexLangstring', lang)
        self[lang].setTitle(title)

    def getDOMBindingNode(self,doc):
        """
        returns a dom-element containing its and all it subobjects dom
        representation
        """
        node=doc.createElement('mediaDescriptor')
        xml.appendText(doc,node,'mediaLocator',self.getMediaLocation())
        nodenote = xml.appendNode(doc,node,'interpretationNote')
        for langstring in self.contentValues():
            langnode=langstring.getDOMBindingNode(doc)
            nodenote.appendChild(langnode)

    def setDOMBindingNode(self,doc,node):
        """ sets data on mediadescriptor given by node """
        # set medialocator
        loc = xml.getData(medianode.getChildrenByTagName('mediaLocator')[0])
        self.setMediaLocation(loc)
        # set name(s)
        notenode=xml.getChildrenByTagName(node,'interpretationNode')[0]
        for langstringnode in xml.getChildrenByTagName(notenode,'langstring'):
            lang=langstringnode.getAttribute('language') or None
            value=xml.getData(langstringnode)
            self.setTitle(value,lang=lang)

    def SearchableText(self):
        return ''

registerType(VdexMediaDescriptor)
# end of class VdexMediaDescriptor
