UNICODE_ENCODINGS = ('utf-7', 'utf-8', 'utf-16', 'utf-16-le', 'utf-16-be',)

_python_encodings = (
    'ascii',
    'base64-codec',
    'cp037',
    'cp1006',
    'cp1026',
    'cp1140',
    'cp1250',
    'cp1251',
    'cp1252',
    'cp1253',
    'cp1254',
    'cp1255',
    'cp1256',
    'cp1257',
    'cp1258',
    'cp424',
    'cp437',
    'cp500',
    'cp737',
    'cp775',
    'cp850',
    'cp852',
    'cp855',
    'cp856',
    'cp857',
    'cp860',
    'cp861',
    'cp862',
    'cp863',
    'cp864',
    'cp865',
    'cp866',
    'cp869',
    'cp874',
    'cp875',
    'idna',
    'iso8859-10',
    'iso8859-13',
    'iso8859-14',
    'iso8859-15',
    'iso8859-1',
    'iso8859-2',
    'iso8859-3',
    'iso8859-4',
    'iso8859-5',
    'iso8859-6',
    'iso8859-7',
    'iso8859-8',
    'iso8859-9',
    'koi8-r',
    'koi8-u',
    'latin-1',
    'mac-cyrillic',
    'mac-greek',
    'mac-iceland',
    'mac-latin2',
    'mac-roman',
    'mac-turkish',
    'mbcs',
    'palmos',
    'punycode',
    'quopri-codec',
    'raw-unicode-escape',
    'rot-13',
    'string-escape',
    'unicode-escape',
    'unicode-internal',
    'utf-16-be',
    'utf-16-le',
    'utf-16',
    'utf-7',
    'utf-8',
)

_utf8enc2latex_mapping = {

# found in uft8enc.dfu (LaTeX)
u'\u00A0': r'{~}',
u'\u00A1': r'{\textexclamdown}',
u'\u00A2': r'{\textcent}',
u'\u00A3': r'{\textsterling}',
u'\u00A4': r'{\textcurrency}',
u'\u00A5': r'{\textyen}',
u'\u00A6': r'{\textbrokenbar}',
u'\u00A7': r'{\textsection}',
u'\u00A8': r'{\textasciidieresis}',
u'\u00A9': r'{\textcopyright}',
u'\u00AA': r'{\textordfeminine}',
u'\u00AB': r'{\guillemotleft}',
u'\u00AC': r'{\textlnot}',
u'\u00AE': r'{\textregistered}',
u'\u00AF': r'{\textasciimacron}',
u'\u00B0': r'{\textdegree}',
u'\u00B1': r'{\textpm}',
u'\u00B2': r'{\texttwosuperior}',
u'\u00B3': r'{\textthreesuperior}',
u'\u00B4': r'{\textasciiacute}',
u'\u00B5': r'{\textmu}', 
u'\u00B6': r'{\textparagraph}',
u'\u00B7': r'{\textperiodcentered}',
u'\u00B8': r'{\c\ }',
u'\u00B9': r'{\textonesuperior}',
u'\u00BA': r'{\textordmasculine}',
u'\u00BB': r'{\guillemotright}',
u'\u00BC': r'{\textonequarter}',
u'\u00BD': r'{\textonehalf}',
u'\u00BE': r'{\textthreequarters}',
u'\u00BF': r'{\textquestiondown}',
u'\u00C0': r'{\a`A}',
u'\u00C1': r'{\a\'A}',
u'\u00C2': r'{\^A}',
u'\u00C3': r'{\~A}',
u'\u00C4': r'{\"A}',
u'\u00C5': r'{\r A}',
u'\u00C6': r'{\AE}',
u'\u00C7': r'{\c C}',
u'\u00C8': r'{\a`E}',
u'\u00C9': r'{\a\'E}',
u'\u00CA': r'{\^E}',
u'\u00CB': r'{\"E}',
u'\u00CC': r'{\a`I}',
u'\u00CD': r'{\a\'I}',
u'\u00CE': r'{\^I}',
u'\u00CF': r'{\"I}',
u'\u00D0': r'{\DH}',
u'\u00D1': r'{\~N}',
u'\u00D2': r'{\a`O}',
u'\u00D3': r'{\a\'O}',
u'\u00D4': r'{\^O}',
u'\u00D5': r'{\~O}',
u'\u00D6': r'{\"O}',
u'\u00D7': r'{\texttimes}',
u'\u00D8': r'{\O}',
u'\u00D9': r'{\a`U}',
u'\u00DA': r'{\a\'U}',
u'\u00DB': r'{\^U}',
u'\u00DC': r'{\"U}',
u'\u00DD': r'{\a\'Y}',
u'\u00DE': r'{\TH}',
u'\u00DF': r'{\ss}',
u'\u00E0': r'{\a`a}',
u'\u00E1': r'{\a\'a}',
u'\u00E2': r'{\^a}',
u'\u00E3': r'{\~a}',
u'\u00E4': r'{\"a}',
u'\u00E5': r'{\r a}',
u'\u00E6': r'{\ae}',
u'\u00E7': r'{\c c}',
u'\u00E8': r'{\a`e}',
u'\u00E9': r'{\a\'e}',
u'\u00EA': r'{\^e}',
u'\u00EB': r'{\"e}',
u'\u00EC': r'{\a`\i}',
u'\u00ED': r'{\a\'\i}',
u'\u00EE': r'{\^\i}',
u'\u00EF': r'{\"\i}',
u'\u00F0': r'{\dh}',
u'\u00F1': r'{\~n}',
u'\u00F2': r'{\a`o}',
u'\u00F3': r'{\a\'o}',
u'\u00F4': r'{\^o}',
u'\u00F5': r'{\~o}',
u'\u00F6': r'{\"o}',
u'\u00F7': r'{\textdiv}',
u'\u00F8': r'{\o}',
u'\u00F9': r'{\a`u}',
u'\u00FA': r'{\a\'u}',
u'\u00FB': r'{\^u}',
u'\u00FC': r'{\"u}',
u'\u00FD': r'{\a\'y}',
u'\u00FE': r'{\th}',
u'\u00FF': r'{\"y}',
u'\u0102': r'{\u A}',
u'\u0103': r'{\u a}',
u'\u0104': r'{\k A}',
u'\u0105': r'{\k a}',
u'\u0106': r'{\a\'C}',
u'\u0107': r'{\a\'c}',
u'\u010C': r'{\v C}',
u'\u010D': r'{\v c}',
u'\u010E': r'{\v D}',
u'\u010F': r'{\v d}',
u'\u0110': r'{\DJ}',
u'\u0111': r'{\dj}',
u'\u0118': r'{\k E}',
u'\u0119': r'{\k e}',
u'\u011A': r'{\v E}',
u'\u011B': r'{\v e}',
u'\u011E': r'{\u G}',
u'\u011F': r'{\u g}',
u'\u0130': r'{\.I}',
u'\u0131': r'{\i}',
u'\u0139': r'{\a\'L}',
u'\u013A': r'{\a\'l}',
u'\u013D': r'{\v L}',
u'\u013E': r'{\v l}',
u'\u0141': r'{\L}',
u'\u0142': r'{\l}',
u'\u0143': r'{\a\'N}',
u'\u0144': r'{\a\'n}',
u'\u0147': r'{\v N}',
u'\u0148': r'{\v n}',
u'\u014A': r'{\NG}',
u'\u014B': r'{\ng}',
u'\u0150': r'{\H O}',
u'\u0151': r'{\H o}',
u'\u0152': r'{\OE}',
u'\u0153': r'{\oe}',
u'\u0154': r'{\a\'R}',
u'\u0155': r'{\a\'r}',
u'\u0158': r'{\v R}',
u'\u0159': r'{\v r}',
u'\u015A': r'{\a\'S}',
u'\u015B': r'{\a\'s}',
u'\u015E': r'{\c S}',
u'\u015F': r'{\c s}',
u'\u0160': r'{\v S}',
u'\u0161': r'{\v s}',
u'\u0162': r'{\c T}',
u'\u0163': r'{\c t}',
u'\u0164': r'{\v T}',
u'\u0165': r'{\v t}',
u'\u016E': r'{\r U}',
u'\u016F': r'{\r u}',
u'\u0170': r'{\H U}',
u'\u0171': r'{\H u}',
u'\u0178': r'{\"Y}',
u'\u0179': r'{\a\'Z}',
u'\u017A': r'{\a\'z}',
u'\u017B': r'{\.Z}',
u'\u017C': r'{\.z}',
u'\u017D': r'{\v Z}',
u'\u017E': r'{\v z}',
u'\u0192': r'{\textflorin}',
u'\u02C6': r'{\textasciicircum}',
u'\u02C7': r'{\textasciicaron}',
u'\u02CA': r'{\textasciitilde}',
u'\u02D8': r'{\textasciibreve}',
u'\u02D9': r'{\textperiodcentered}',
u'\u02DD': r'{\textacutedbl}',
u'\u0401': r'{\CYRYO}',
u'\u0402': r'{\CYRDJE}',
u'\u0404': r'{\CYRIE}',
u'\u0405': r'{\CYRDZE}',
u'\u0406': r'{\CYRII}',
u'\u0407': r'{\CYRYI}',
u'\u0408': r'{\CYRJE}',
u'\u0409': r'{\CYRLJE}',
u'\u040A': r'{\CYRNJE}',
u'\u040B': r'{\CYRTSHE}',
u'\u040E': r'{\CYRUSHRT}',
u'\u040F': r'{\CYRDZHE}',
u'\u0410': r'{\CYRA}',
u'\u0411': r'{\CYRB}',
u'\u0412': r'{\CYRV}',
u'\u0413': r'{\CYRG}',
u'\u0414': r'{\CYRD}',
u'\u0415': r'{\CYRE}',
u'\u0416': r'{\CYRZH}',
u'\u0417': r'{\CYRZ}',
u'\u0418': r'{\CYRI}',
u'\u0419': r'{\CYRISHRT}',
u'\u041A': r'{\CYRK}',
u'\u041B': r'{\CYRL}',
u'\u041C': r'{\CYRM}',
u'\u041D': r'{\CYRN}',
u'\u041E': r'{\CYRO}',
u'\u041F': r'{\CYRP}',
u'\u0420': r'{\CYRR}',
u'\u0421': r'{\CYRS}',
u'\u0422': r'{\CYRT}',
u'\u0423': r'{\CYRU}',
u'\u0424': r'{\CYRF}',
u'\u0425': r'{\CYRH}',
u'\u0426': r'{\CYRC}',
u'\u0427': r'{\CYRCH}',
u'\u0428': r'{\CYRSH}',
u'\u0429': r'{\CYRSHCH}',
u'\u042A': r'{\CYRHRDSN}',
u'\u042B': r'{\CYRERY}',
u'\u042C': r'{\CYRSFTSN}',
u'\u042D': r'{\CYREREV}',
u'\u042E': r'{\CYRYU}',
u'\u042F': r'{\CYRYA}',
u'\u0430': r'{\cyra}',
u'\u0431': r'{\cyrb}',
u'\u0432': r'{\cyrv}',
u'\u0433': r'{\cyrg}',
u'\u0434': r'{\cyrd}',
u'\u0435': r'{\cyre}',
u'\u0436': r'{\cyrzh}',
u'\u0437': r'{\cyrz}',
u'\u0438': r'{\cyri}',
u'\u0439': r'{\cyrishrt}',
u'\u043A': r'{\cyrk}',
u'\u043B': r'{\cyrl}',
u'\u043C': r'{\cyrm}',
u'\u043D': r'{\cyrn}',
u'\u043E': r'{\cyro}',
u'\u043F': r'{\cyrp}',
u'\u0440': r'{\cyrr}',
u'\u0441': r'{\cyrs}',
u'\u0442': r'{\cyrt}',
u'\u0443': r'{\cyru}',
u'\u0444': r'{\cyrf}',
u'\u0445': r'{\cyrh}',
u'\u0446': r'{\cyrc}',
u'\u0447': r'{\cyrch}',
u'\u0448': r'{\cyrsh}',
u'\u0449': r'{\cyrshch}',
u'\u044A': r'{\cyrhrdsn}',
u'\u044B': r'{\cyrery}',
u'\u044C': r'{\cyrsftsn}',
u'\u044D': r'{\cyrerev}',
u'\u044E': r'{\cyryu}',
u'\u044F': r'{\cyrya}',
u'\u0451': r'{\cyryo}',
u'\u0452': r'{\cyrdje}',
u'\u0454': r'{\cyrie}',
u'\u0455': r'{\cyrdze}',
u'\u0456': r'{\cyrii}',
u'\u0457': r'{\cyryi}',
u'\u0458': r'{\cyrje}',
u'\u0459': r'{\cyrlje}',
u'\u045A': r'{\cyrnje}',
u'\u045B': r'{\cyrtshe}',
u'\u045E': r'{\cyrushrt}',
u'\u045F': r'{\cyrdzhe}',
u'\u0462': r'{\CYRYAT}',
u'\u0463': r'{\cyryat}',
u'\u046A': r'{\CYRBYUS}',
u'\u046B': r'{\cyrbyus}',
u'\u0472': r'{\CYRFITA}',
u'\u0473': r'{\cyrfita}',
u'\u0474': r'{\CYRIZH}',
u'\u0475': r'{\cyrizh}',
u'\u048C': r'{\CYRSEMISFTSN}',
u'\u048D': r'{\cyrsemisftsn}',
u'\u048E': r'{\CYRRTICK}',
u'\u048F': r'{\cyrrtick}',
u'\u0490': r'{\CYRGUP}',
u'\u0491': r'{\cyrgup}',
u'\u0492': r'{\CYRGHCRS}',
u'\u0493': r'{\cyrghcrs}',
u'\u0494': r'{\CYRGHK}',
u'\u0495': r'{\cyrghk}',
u'\u0496': r'{\CYRZHDSC}',
u'\u0497': r'{\cyrzhdsc}',
u'\u0498': r'{\CYRZDSC}',
u'\u0499': r'{\cyrzdsc}',
u'\u049A': r'{\CYRKDSC}',
u'\u049B': r'{\cyrkdsc}',
u'\u049C': r'{\CYRKVCRS}',
u'\u049D': r'{\cyrkvcrs}',
u'\u049E': r'{\CYRKHCRS}',
u'\u049F': r'{\cyrkhcrs}',
u'\u04A0': r'{\CYRKBEAK}',
u'\u04A1': r'{\cyrkbeak}',
u'\u04A2': r'{\CYRNDSC}',
u'\u04A3': r'{\cyrndsc}',
u'\u04A4': r'{\CYRNG}',
u'\u04A5': r'{\cyrng}',
u'\u04A6': r'{\CYRPHK}',
u'\u04A7': r'{\cyrphk}',
u'\u04A8': r'{\CYRABHHA}',
u'\u04A9': r'{\cyrabhha}',
u'\u04AA': r'{\CYRSDSC}',
u'\u04AB': r'{\cyrsdsc}',
u'\u04AC': r'{\CYRTDSC}',
u'\u04AD': r'{\cyrtdsc}',
u'\u04AE': r'{\CYRY}',
u'\u04AF': r'{\cyry}',
u'\u04B0': r'{\CYRYHCRS}',
u'\u04B1': r'{\cyryhcrs}',
u'\u04B2': r'{\CYRHDSC}',
u'\u04B3': r'{\cyrhdsc}',
u'\u04B4': r'{\CYRTETSE}',
u'\u04B5': r'{\cyrtetse}',
u'\u04B6': r'{\CYRCHRDSC}',
u'\u04B7': r'{\cyrchrdsc}',
u'\u04B8': r'{\CYRCHVCRS}',
u'\u04B9': r'{\cyrchvcrs}',
u'\u04BA': r'{\CYRSHHA}',
u'\u04BB': r'{\cyrshha}',
u'\u04BC': r'{\CYRABHCH}',
u'\u04BD': r'{\cyrabhch}',
u'\u04BE': r'{\CYRABHCHDSC}',
u'\u04BF': r'{\cyrabhchdsc}',
u'\u04C0': r'{\CYRpalochka}',
u'\u04C3': r'{\CYRKHK}',
u'\u04C4': r'{\cyrkhk}',
u'\u04C5': r'{\CYRLDSC}',
u'\u04C6': r'{\cyrldsc}',
u'\u04C7': r'{\CYRNHK}',
u'\u04C8': r'{\cyrnhk}',
u'\u04CB': r'{\CYRCHLDSC}',
u'\u04CC': r'{\cyrchldsc}',
u'\u04CD': r'{\CYRMDSC}',
u'\u04CE': r'{\cyrmdsc}',
u'\u04D4': r'{\CYRAE}',
u'\u04D5': r'{\cyrae}',
u'\u04D8': r'{\CYRSCHWA}',
u'\u04D9': r'{\cyrschwa}',
u'\u04E0': r'{\CYRABHDZE}',
u'\u04E1': r'{\cyrabhdze}',
u'\u04E8': r'{\CYROTLD}',
u'\u04E9': r'{\cyrotld}',
u'\u0E37': r'{\textbaht}',
u'\u200C': r'{\textcompwordmark}',
u'\u2013': r'{\textendash}',
u'\u2014': r'{\textemdash}',
u'\u2016': r'{\textbardbl}',
u'\u2018': r'{\textquoteleft}',
u'\u2019': r'{\textquoteright}',
u'\u201A': r'{\quotesinglbase}',
u'\u201C': r'{\textquotedblleft}',
u'\u201D': r'{\textquotedblright}',
u'\u201E': r'{\quotedblbase}',
u'\u2020': r'{\textdagger}',
u'\u2021': r'{\textdaggerdbl}',
u'\u2022': r'{\textbullet}',
u'\u2026': r'{\textellipsis}',
u'\u2030': r'{\textperthousand}',
u'\u2031': r'{\textpertenthousand}',
u'\u2039': r'{\guilsinglleft}',
u'\u203A': r'{\guilsinglright}',
u'\u203B': r'{\textreferencemark}',
u'\u203D': r'{\textinterrobang}',
u'\u2044': r'{\textfractionsolidus}',
u'\u204E': r'{\textasteriskcentered}',
u'\u2052': r'{\textdiscount}',
u'\u20A1': r'{\textcolonmonetary}',
u'\u20A4': r'{\textlira}',
u'\u20A6': r'{\textnaira}',
u'\u20A9': r'{\textwon}',
u'\u20AB': r'{\textdong}',
u'\u20AC': r'{\texteuro}',
u'\u20B1': r'{\textpeso}',
u'\u2103': r'{\textcelsius}',
u'\u2116': r'{\textnumero}',
u'\u2117': r'{\textcircledP}',
u'\u211E': r'{\textrecipe}',
u'\u2120': r'{\textservicemark}',
u'\u2122': r'{\texttrademark}',
u'\u2126': r'{\textohm}',
u'\u2127': r'{\textmho}',
u'\u212E': r'{\textestimated}',
u'\u2190': r'{\textleftarrow}',
u'\u2191': r'{\textuparrow}',
u'\u2192': r'{\textrightarrow}',
u'\u2193': r'{\textdownarrow}',
u'\u2212': r'{\textminus}',
u'\u2329': r'{\textlangle}',
u'\u232A': r'{\textrangle}',
u'\u2422': r'{\textblank}',
u'\u2423': r'{\textvisiblespace}',
u'\u25E6': r'{\textopenbullet}',
u'\u25EF': r'{\textbigcircle}',
u'\u266A': r'{\textmusicalnote}',

# not in utf8enc.dfu
u'\u2190': r'{\leftarrow}',

# need LaTeX math mode... 
u'\u2032': r'{$\prime$}',
u'\u2261': r'{$\equiv$}',

# greek alphabet, also math mode TODO!!!
#u'\u0000': r'{$\alpha$}',
#u'\u0000': r'{$\beta$}',
#u'\u0000': r'{$\gamma$}',
#u'\u0000': r'{$\delta$}',
#u'\u0000': r'{$\epsilon$}',
#u'\u0000': r'{$\varepsilon$}',
#u'\u0000': r'{$\zeta$}',
#u'\u0000': r'{$\eta$}',
#u'\u0000': r'{$\theta$}',
#u'\u0000': r'{$\vartheta$}',
#u'\u0000': r'{$\iota$}',
#u'\u0000': r'{$\kappa$}',
#u'\u0000': r'{$\lambda$}',
#u'\u0000': r'{$\mu$}',
u'\u03BD': r'{$\nu$}',
#u'\u0000': r'{$\xi$}',
#u'\u0000': r'{$\pi$}',
#u'\u0000': r'{$\varpi$}',
#u'\u0000': r'{$\rho$}',
#u'\u0000': r'{$\varrho$}',
#u'\u0000': r'{$\sigma$}',
#u'\u0000': r'{$\varsigma$}',
#u'\u0000': r'{$\tau$}',
#u'\u0000': r'{$\upsilon$}',
#u'\u0000': r'{$\phi$}',
#u'\u0000': r'{$\varphi$}',
u'\u03a7': r'{$\chi$}',
#u'\u0000': r'{$\psi$}',
#u'\u0000': r'{$\omega$}',
#u'\u0000': r'{$\Gamma$}',
#u'\u0000': r'{$\Delta$}',
#u'\u0000': r'{$\Theta$}',
#u'\u0000': r'{$\Lambda$}',
#u'\u0000': r'{$\Xi$}',
#u'\u0000': r'{$\Pi$}',
#u'\u0000': r'{$\Sigma$}',
#u'\u0000': r'{$\Upsilon$}',
#u'\u0000': r'{$\Phi$}',
#u'\u0000': r'{$\Psi$}',
#u'\u0000': r'{$\Omega$}',

}

# assume the latex / utf8 mapping is bijective
_latex2utf8enc_mapping = {}
for unicode_char in _utf8enc2latex_mapping.keys():
    _latex2utf8enc_mapping[_utf8enc2latex_mapping[unicode_char]] = unicode_char

