##########################################################################
#                                                                        #
#           copyright (c) 2003 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""Miscellanous reference class"""

from AccessControl import ClassSecurityInfo
from Products.CMFCore.permissions import View

from Products.CMFBibliographyAT.config import CMFBAT_USES_LINGUAPLONE
if CMFBAT_USES_LINGUAPLONE:
    from Products.LinguaPlone.public import Schema
    from Products.LinguaPlone.public import StringField, StringWidget
else:
    from Products.Archetypes.public import Schema
    from Products.Archetypes.public import StringField, StringWidget
from Products.Archetypes.public import registerType

from Products.CMFBibliographyAT.config import PROJECTNAME
from Products.CMFBibliographyAT.content.base import BaseEntry
from Products.CMFBibliographyAT.content.schemata \
    import HeaderSchema, AuthorSchema, CoreSchema, TrailingSchema
from Products.CMFBibliographyAT.content.fields import howpublishedField


howpublishedspecificField = howpublishedField.copy()
howpublishedspecificField.default = ''
SourceSchema = Schema((
    howpublishedspecificField,
     ))

MiscSchema = HeaderSchema.copy() + AuthorSchema.copy() + CoreSchema.copy() +  \
             SourceSchema.copy() + TrailingSchema.copy()
MiscSchema.get('authors').required = 0
# normally the publication_year for MiscReferences is optional, but
# in CMFBAT we better force the user to enter something here (better not
# irritate portal_catalog...).
MiscSchema.get('publication_year').required = 1 

# the default AT 'description' field shall be invisible, it is kept in sync with the 'abstract' field
MiscSchema.get('description').widget.visible = {'view': 'invisible', 'edit': 'invisible', }

class MiscReference(BaseEntry):
    """ content type to make reference to miscellaneous publications.
    """
    security = ClassSecurityInfo()
    archetype_name = "Misc Reference"
    source_fields = ('howpublished',)

    schema = MiscSchema
    
    security.declareProtected(View, 'Source')
    def Source(self):
        """ the default misc source format
        """
        try:

            return self.MiscSource()

        except AttributeError:

            howpublished = self.getHowpublished()
	    
            source = 'Miscellaneous publication'
            if howpublished: source += ', %s' % howpublished
	    
            return source + '.'


registerType(MiscReference, PROJECTNAME)
