/*
 * Author: Romaric BREIL <romaric.breil@supinfo.com>
 *
 * Those functions allow to manage Plomino dynamic views.
 */

// Add checkboxes in the first column and links to documents in the others (see DataTables documentation)
function dynamicview_generate_cells_content(oObj) {
	var cell = oObj.aData[oObj.iDataColumn];
	if (oObj.iDataColumn > 0) {
		if (findInArray(cell, '<a') == -1) {
			return '<a href="' + oObj.aData[0] + '" class="viewlink">' + cell + '</a>';
		}
		else
			return cell;
	}
	else {
		return '<input type="checkbox" value="' + oObj.aData[0] + '" />';
	}
}

// indexOf implementation for arrays
function findInArray(array, value) {
	var length = array.length;
	for (var i = 0; i < length; i++)
		if (array[i] == value)
			return i;
	return -1;
}

// Expand or collapse a category
function dynamicview_toggle_category(nRow) {
	var row = jq(nRow);
	row.toggleClass("expanded").toggleClass("collapsed");
	dynamicview_refresh_categories(row.closest("table"));
}

// Refresh table by collapsing and expanding every category
function dynamicview_refresh_categories(nTable) {
	var table = jq(nTable);
	var collapsed = false;
	jq("tbody tr", table).each(function() {
		var row = jq(this);
		// it is a header
		if (row.hasClass("collapsed")) {
			collapsed = true;
			jq("td:eq(0)", row).html("<img src='list-add.png' alt='Collapse' />");
		}
		else if(row.hasClass("expanded")) {
			collapsed = false;
			jq("td:eq(0)", row).html("<img src='list-remove.png' alt='Extpand' />");
		}
		// it is a row
		else {
			if (collapsed)
				row.hide();
			else
				row.show();
		}
	});

	// refresh the table asExpanded, stored in the table data
	var asExpanded = [];
	jq("tbody tr.expanded", table).each(function() {
		asExpanded.push(jq(this).text());
	});
	table.data("asExpanded", asExpanded);
}

// Generates categories (must be called when the table is re-drawn
function dynamicview_categorize(sTableId) {
	var table = jq('#' + sTableId);
	// add categories headers
	jq('tbody tr', table).each(function(index, element) {
		var row = jq(this);
		var category = jq('td:eq(1)', this).text();
		if (index == 0 || category != row.prev().children("td:eq(1)").text()) {
			var asExpanded = table.data("asExpanded") || [];
			var classname = findInArray(asExpanded, category) == -1 ? "collapsed" : "expanded";
			var colspan = row.children().length - 1;
			row.before('<tr onclick="dynamicview_toggle_category(this);" class="' + classname + '"><td class="group"></td><td class="group" colspan="' + colspan + '">' + category + '</td></tr>');
		}
	});
	jq('tbody tr:not(.collapsed,.expanded)', table).each(function(){
		jq('td:eq(1) a', this).hide();
	});
	// hide collapsed rows
	dynamicview_refresh_categories(table);
}

// Generates the footer of the dynamic datagrid view (generated by JQuery DataTable)
function generateTableFooter(nFoot, aasData, iStart, iEnd, aiDisplay ) {
	// Will be set as true if a sum is computed
	var hasSums = false;
	
	if (aiDisplay.length > 0) {
		// Table which stores sums
		var result = [];
		jq('#dynamictable > thead > tr:first-child > th:visible').each(function (index, element) {
			if (jq(element).hasClass('displaysum'))
				result[index] = 0;
			else
				result[index] = NaN;
		});
		
		// Sums computation of displayed data
		for (var i = 0; i < aiDisplay.length; i++) {
			for (var j = 0; j < result.length; j++) {
				if (!isNaN(result[j]))
					result[j] += Number(aasData[aiDisplay[i]][j]);
			}
		}
		
		// Display of sums
		for (var i = 0; i < result.length; i++) {
			// Replace NaN by ""
			var colResult = result[i];
			if (isNaN(colResult))
				colResult = "";
			else
				hasSums = true;
			jq('th', nFoot).eq(i).text(colResult);
		}
	}
	
	// Display the footer if there is sums to display
	if (!hasSums)
    	jq(nFoot).hide();
	else
		jq(nFoot).show();
}

// Returns a string storing every selected documents, separated by '@'
function dynamicview_selecteddocuments() {
	var docs = jq('input:checked', oDynamicTable.fnGetNodes()).get();
	var docids = "";
	for (var i = 0; i < docs.length; i++)
		docids += docs[i].value + '@';
	
	return docids;
}
