""" 
User interface
"""
from zope.interface import Interface

from Products.Archetypes.interfaces import IReferenceable

from Products.PluggableAuthService.interfaces.plugins import \
     IAuthenticationPlugin
from Products.PluggableAuthService.interfaces.plugins import IGroupsPlugin
from Products.PluggableAuthService.interfaces.plugins import IRolesPlugin
from Products.PlonePAS.interfaces.plugins import IUserManagement

from Products.PlonePAS.interfaces.plugins import IMutablePropertiesPlugin

class IMembraneUser(Interface):
    """
    A marker interface for the MembraneUser objects generated by the
    user factory.
    """

class IUserRelated(Interface):
    """
    Needs to be implemented by anything user-related so we can easily
    determine the unique user that the object is related to.
    """
    def getUserId():
        """
        Return the unique identifier for the user that this piece of
        content relates to.
        """

class IMembraneUserAuth(IUserRelated, IAuthenticationPlugin):
    """
    Used for objects that can handle user authentication.
    """

class IMembraneUserProperties(IUserRelated, IMutablePropertiesPlugin):
    """
    Used for objects that can provide user properties.
    """

class IMembraneUserGroups(IUserRelated, IGroupsPlugin):
    """
    Used for objects that can provide user groups.
    """

class IMembraneUserRoles(IUserRelated, IRolesPlugin):
    """
    Used for objects that can provide user roles.
    """

class IMembraneUserManagement(IUserRelated, IUserManagement):
    """
    Used to change the password and delete objects.
    """

class IMembraneUserChanger(IUserRelated):
    """
    Provide a method to change a user
    """
    def doChangeUser(login, password, **kwargs):
        """change the password for a given user"""

class IMembraneUserDeleter(IUserRelated):
    """
    Used to delete member objects
    """
    def doDeleteUser(login):
        """remove the user with the id login"""
