# PyAlgoTrade
# 
# Copyright 2012 Gabriel Martin Becedillas Ruiz
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#   http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
.. moduleauthor:: Gabriel Martin Becedillas Ruiz <gabriel.becedillas@gmail.com>
"""

from pyalgotrade import technical
from pyalgotrade import dataseries

class ROCEventWindow(technical.EventWindow):
	def __init__(self, windowSize):
		technical.EventWindow.__init__(self, windowSize)

	def getValue(self):
		ret = None
		if self.windowFull():
			prev = self.getValues()[0]
			actual = self.getValues()[-1]
			if actual != None and prev != None and prev != 0:
				ret = (actual - prev) / float(prev)
		return ret

class RateOfChange(technical.EventBasedFilter):
	"""Rate of change filter as described in http://stockcharts.com/school/doku.php?id=chart_school:technical_indicators:rate_of_change.

	:param dataSeries: The DataSeries instance being filtered.
	:type dataSeries: :class:`pyalgotrade.dataseries.DataSeries`.
	:param valuesAgo: The number of values back that a given value will compare to. Must be > 0.
	:type valuesAgo: int.
	:param maxLen: The maximum number of values to hold. If not None, it must be greater than 0.
		Once a bounded length is full, when new items are added, a corresponding number of items are discarded from the opposite end.
	:type maxLen: int.
	"""

	def __init__(self, dataSeries, valuesAgo, maxLen=dataseries.DEFAULT_MAX_LEN):
		assert(valuesAgo > 0)
		technical.EventBasedFilter.__init__(self, dataSeries, ROCEventWindow(valuesAgo + 1), maxLen)

