#! /usr/bin/env python

"""
This script plots the frequency response magnitude for a 1 zero, 2 pole filter.

Original Author: David Banas
Original Date:   October 25, 2014

Copyright (c) 2014 David Banas; All rights reserved World wide.
"""

from pylab        import *
from scipy.signal import invres, freqs
from numpy        import pi, log10

# Simulation control
f_min = 10.e6  # min. frequency (Hz)
f_max = 10.e9  # max. frequency (Hz)
pi    = 1.e6     # |Im{pole}|

# Pole/zero definitions
z  = 2 * pi * 50.e6
p1 = 2 * pi * (-1.e9 + 1j * pi)
p2 = 2 * pi * (-1.e9 - 1j * pi)

# Convert to pole/residue form, for use in 'invres()'.
r1 = (z - p1) / (p2 - p1)
r2 = 1 - r1

# Convert pole/residue filter description into numerator/denominator polynomials.
# And calculate the response.
b, a = invres([r1, r2], [p1, p2], [])
f    = arange(f_min, f_max, f_min)
ws   = 2. * pi * f
w, H = freqs(b, a, ws)

# Plot the result.
semilogx(w / (2 * pi), 20. * log10(abs(H)))
title("Frequency Response Magnitude")
xlabel("f (Hz)")
ylabel("|H(f)| (dB)")
grid()
show()

