__author__ = 'Tom Schaul, tom@idsia.ch'

import copy

from pybrain.utilities import abstractMethod, Named
    
        
class Evolvable(Named):
    """ The interface for all evolvables, i.e. which implement mutation, randomize and copy operators. """   
        
    def mutate(self, **args):
        """ Vary some properties of the underlying module, so that it's behavior 
        changes, (but not too abruptly). """
        abstractMethod()
        
    def copy(self):
        """ by default a full deep copy - subclasses should implement something faster, if appropriate. """
        return copy.deepcopy(self)
        
    def randomize(self):
        """ randomly set all variable parameters """
        abstractMethod()
        
    def newSimilarInstance(self):
        """ generate a new Evolvable with the same maximal complexity """
        res = self.copy()
        res.randomize()
        return res