#!/usr/bin/env python
import requests
import sys
from exceptions import *
from device import *

class PyBullet(object):

    URL = "https://api.pushbullet.com/api/"
    APIKEY = ("", "")
    TYPES =  {"note": ["title", "body"], "link": ["title", "url"],
              "address": ["name", "address"], "list": ["title", "items"]}
    devices = []

    def __init__(self, api_key):
        self.APIKEY = (api_key, "")
        self.updateDevices()

    def getApiKey(self):
        return self.APIKEY[0]

    def updateApiKey(self, api_key):
        self.APIKEY = (api_key, "")
        self.updateDevices()

    def updateDevices(self):

        url = self.URL + 'devices'

        r = requests.get(url, auth=self.APIKEY)
        if r.ok:
            devices = r.json()['devices']
            self.devices = [Device(device) for device in devices]
        else:
            try:
                obj = r.json()
            except ValueError:
                obj = None
            finally:
                raise PyBulletAPIError(r.status_code, obj)
        return self.devices

    def getDevices(self):
        if len(self.devices) == 0:
            return self.updateDevices()
        else:
            return self.devices

    def getDeviceByNick(self, nick):
        return [dev for dev in self.getDevices() if dev.nick == nick]

    def getDeviceByIden(self, iden):
        return [dev for dev in self.getDevices() if dev.iden == iden]

    def getTypes(self):
        return self.TYPES.keys()

    def getTypeAttr(self, type):
        if self.TYPES.has_key(type):
            return self.TYPES[type]
        else:
            raise PyBulletTypeError(type)

    def push(self, device, type="note", **kwargs):
        url = self.URL + 'pushes'
        dev = self.getDeviceByNick(device)
        if not len(dev):
            raise PyBulletDeviceError(device)
        elif not self.TYPES.has_key(type):
            raise PyBulletTypeError(type)
        else:
            data = { key: kwargs[key] for key in self.TYPES[type] if kwargs.has_key(key)}
            data['device_iden'] = dev[0].iden
            data['type'] = type
            r = requests.post(url, auth=self.APIKEY, data=data)
