#!/usr/bin/env python

class PyBulletError(Exception):
    """Base class for exception in PyBullet"""
    pass


class PyBulletAPIError(PyBulletError):

    HTTPERROR = { 400: "missing a required parameter.",
                  401: "no valid API key provided.",
                  402: "parameters were valid but the request failed.",
                  403: "the API key is not valid for that request.",
                  404: "the requested item doesn't exist.",
                  500: "something went wrong on PushBullet's side."
    }

    def __init__(self, code, json):
        self.code = code
        self.json = json
        if json:
            self.msg = json['error']['message']
        else:
            self.msg = (self.HTTPERROR[code] if code in self.HTTPERROR.keys()
                        else "Unknown error.")

    def __str__(self):
        return "%s: %s"% (self.code, self.msg)


class PyBulletArgumentError(PyBulletError):

    MSG = "argument is invalid."

    def __init__(self, arg):
        self.expr = arg

    def __str__(self):
        return "%s %s"% (self.expr, self.MSG)


class PyBulletTypeError(PyBulletArgumentError):

    MSG = "is not a valid push type."


class PyBulletDeviceError(PyBulletArgumentError):

    MSG = "is not in your devices list."
