# Copyright (C) 2010 Richard Lincoln
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA, USA

from CIM14.IEC61970.Wires.Switch import Switch

class Fuse(Switch):
    """An overcurrent protective device with a circuit opening fusible part that is heated and severed by the passage of overcurrent through it. A fuse is considered a switching device because it breaks current.
    """

    def __init__(self, ratingCurrent=0.0, *args, **kw_args):
        """Initialises a new 'Fuse' instance.

        @param ratingCurrent: Fault interrupting current rating. 
        """
        #: Fault interrupting current rating.
        self.ratingCurrent = ratingCurrent

        super(Fuse, self).__init__(*args, **kw_args)

    _attrs = ["ratingCurrent"]
    _attr_types = {"ratingCurrent": float}
    _defaults = {"ratingCurrent": 0.0}
    _enums = {}
    _refs = []
    _many_refs = []

