# Copyright (C) 2010 Richard Lincoln
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA, USA

from CIM14.IEC61970.Core.ConductingEquipment import ConductingEquipment

class Conductor(ConductingEquipment):
    """Combination of conducting material with consistent electrical characteristics, building a single electrical system, used to carry current between points in the power system.
    """

    def __init__(self, length=0.0, *args, **kw_args):
        """Initialises a new 'Conductor' instance.

        @param length: Segment length for calculating line section capabilities 
        """
        #: Segment length for calculating line section capabilities
        self.length = length

        super(Conductor, self).__init__(*args, **kw_args)

    _attrs = ["length"]
    _attr_types = {"length": float}
    _defaults = {"length": 0.0}
    _enums = {}
    _refs = []
    _many_refs = []

