# Copyright (C) 2010-2011 Richard Lincoln
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.

from CIM14.ENTSOE.Dynamics.IEC61970.Core.CoreIdentifiedObject import CoreIdentifiedObject

class DynamicsMetaBlockSignal(CoreIdentifiedObject):

    def __init__(self, To=None, From=None, MemberOf_MetaBlock=None, *args, **kw_args):
        """Initialises a new 'DynamicsMetaBlockSignal' instance.

        @param To:
        @param From:
        @param MemberOf_MetaBlock:
        """
        self._To = None
        self.To = To

        self._From = None
        self.From = From

        self._MemberOf_MetaBlock = None
        self.MemberOf_MetaBlock = MemberOf_MetaBlock

        super(DynamicsMetaBlockSignal, self).__init__(*args, **kw_args)

    _attrs = []
    _attr_types = {}
    _defaults = {}
    _enums = {}
    _refs = ["To", "From", "MemberOf_MetaBlock"]
    _many_refs = []

    def getTo(self):
        
        return self._To

    def setTo(self, value):
        if self._To is not None:
            filtered = [x for x in self.To.MetaBlockSignal if x != self]
            self._To._MetaBlockSignal = filtered

        self._To = value
        if self._To is not None:
            if self not in self._To._MetaBlockSignal:
                self._To._MetaBlockSignal.append(self)

    To = property(getTo, setTo)

    def getFrom(self):
        
        return self._From

    def setFrom(self, value):
        if self._From is not None:
            self._From._MetaBlockSignal = None

        self._From = value
        if self._From is not None:
            self._From.MetaBlockSignal = None
            self._From._MetaBlockSignal = self

    From = property(getFrom, setFrom)

    def getMemberOf_MetaBlock(self):
        
        return self._MemberOf_MetaBlock

    def setMemberOf_MetaBlock(self, value):
        if self._MemberOf_MetaBlock is not None:
            filtered = [x for x in self.MemberOf_MetaBlock.MetaBlockSignal if x != self]
            self._MemberOf_MetaBlock._MetaBlockSignal = filtered

        self._MemberOf_MetaBlock = value
        if self._MemberOf_MetaBlock is not None:
            if self not in self._MemberOf_MetaBlock._MetaBlockSignal:
                self._MemberOf_MetaBlock._MetaBlockSignal.append(self)

    MemberOf_MetaBlock = property(getMemberOf_MetaBlock, setMemberOf_MetaBlock)

