
from datetime import datetime
from pylons import config
from sqlalchemy import Column, MetaData, Table, ForeignKey
from sqlalchemy.types import *
from sqlalchemy.orm import scoped_session, sessionmaker
from sqlalchemy.orm import mapper, relation

import pycrud.lib.helpers as h


Session = scoped_session(sessionmaker(autoflush=True, transactional=True,
    bind=config['pylons.g'].sa_engine))

meta = MetaData()


def list(cls):
    return Session.query(cls)

def get(cls, id):
    return Session.query(cls).get(id)


class Base(object):
    rollback = staticmethod(Session.rollback)
    flush = staticmethod(Session.flush)
    commit = staticmethod(Session.commit)
    clear = staticmethod(Session.clear)

    def __init__(self, **kw):
        for k,v in kw.iteritems():
            setattr(self, k, v)

    def __str__(self):
        return '<%s %s>' % (self.__class__.__name__, self.id)

    def delete(self):
        return Session.delete(self)

    def get(cls, id):
        return Session.query(cls).get(id)
    get = classmethod(get)

    def list(cls):
        return Session.query(cls)
    list = classmethod(list)

    def save(self):
        return Session.save(self)

    def save_or_update(self):
        return Session.save_or_update(self)

    def update(self):
        return Session.update(self)


def map_table(tbl, base=Base, **kw):
    class TableClass(base):
        pass
    mapper(TableClass, tbl, **kw)
    return TableClass
map_tbl = map_table


