try:
    from setuptools import setup, find_packages
except ImportError:
    from ez_setup import use_setuptools
    use_setuptools()
    from setuptools import setup, find_packages

setup(
    name='PyCRUD',
    version='0.1.6',
    description='''Pylons Create Read Update Delete template application''',
    author='Emanuel Gardaya Calso',
    author_email='egcalso@gmail.com',
    #url='',
    install_requires=['Pylons>=0.9.6.1', 'SQLAlchemy==0.4.6'],
    packages=find_packages(exclude=['ez_setup']),
    include_package_data=True,
    test_suite='nose.collector',
    package_data={'pycrud': ['i18n/*/LC_MESSAGES/*.mo']},
    #message_extractors = {'pycrud': [
    #        ('**.py', 'python', None),
    #        ('templates/**.mako', 'mako', None),
    #        ('public/**', 'ignore', None)]},
    entry_points="""
    [paste.app_factory]
    main = pycrud.config.middleware:make_app

    [paste.app_install]
    main = pylons.util:PylonsInstaller
    """,
)
