# Setup file for automatic installation of the PyCIFRW
# distribution
from distutils.core import setup, Extension

# The compiled scanner for speed

c_scanner = Extension("StarScan",["lib/lex.yy.c","lib/py_star_scan.c"])

setup(name="PyCifRW",
      version = "3.6.2",
      description = "CIF/STAR file support for Python",
      author = "James Hester",
      author_email = "jamesrhester at gmail.com",
      url="https://bitbucket.org/jamesrhester/pycifrw/wiki/Home",
      py_modules = ['CifFile','yapps3_compiled_rt','YappsStarParser_1_1','YappsStarParser_1_0',
                    'YappsStarParser_DDLm','StarFile'],
      ext_modules = [c_scanner]
      )
