# Copyright (c) 2002 Cunningham & Cunningham, Inc.
# Released under the terms of the GNU General Public License version 2 or later.
# Converted to Python 2003/07/24 by John Roth
# This appears to be a singleton. Python best practice is to convert singletons
#   into modules.


# This discrete event simulator supports three events
# each of which is open coded in the body of the simulator.


import time as timeModule
from fit.ActionFixture import ActionFixture
#from Dialog import Dialog
#import MusicLibrary
#import MusicPlayer


time = timeModule.time() # Time is a float
time = long(time) * 1000 # convert to milliseconds as int.

nextSearchComplete = 0
nextPlayStarted = 0
nextPlayComplete = 0

def nextEvent(bound):
    result = bound
    result = sooner(result, nextSearchComplete)
    result = sooner(result, nextPlayStarted)
    result = sooner(result, nextPlayComplete)
    return result

def sooner(soon, event):
    if time < event < soon: return event
    else: return soon

def perform():
    if time == nextSearchComplete:
        MusicLibrary.searchComplete()
    if time == nextPlayStarted:
        MusicPlayer.playStarted()
    if time == nextPlayComplete:
        MusicPlayer.playComplete()

def advance(future):
    global time
    while time < future:
        time = nextEvent(future)
        perform()

def schedule(seconds):
    return time + int(seconds * 1000)

def delay(seconds):
    advance(schedule(seconds))

def waitSearchComplete():
    advance(nextSearchComplete)

def waitPlayStarted():
    advance(nextPlayStarted)

def waitPlayComplete():
    advance(nextPlayComplete)

def failLoadJam():
    ActionFixture.actor = Dialog("load jamed", ActionFixture.actor)


