# ExpandErrorMessage fixture from Python FIT acceptance test suite
#LegalNotices jhr2005
#endLegalNotices

from fit.ColumnFixture import ColumnFixture
from fit.FitException import FitException, KindOfMessage, TraceWanted
from fit.Utilities import em

class ExpandErrorMessage(ColumnFixture):
    _typeDict = {"args": "Tuple",
                 "args.columnType": "given",
                 "exception": KindOfMessage,
                 "exception.columnType": "result",
                 "Trace": TraceWanted,
                 "Trace.columnType": "result",
                 "Message": "String",
                 "Message.columnType": "result",
                 "notes.columnType": "comment",
                 }

    def args(self, aTuple):
#        em("\nargs: '%s'" % (aTuple,))
        excObj = FitException(*aTuple)
#        em("argsInFitException: '%s'" % (excObj.args,))
        self.exc, self.trace, self.message = excObj.getMeaningfulMessage()
        
    def exception(self):
        return KindOfMessage(self.exc)

    def Trace(self):
        return TraceWanted(self.trace)

    def Message(self):
        return self.message