# Utility routines and other miscellaney
# Copyright 2005 John H. Roth Jr.
# Released under the terms of the GNU General Public License, version 2.0 or later.
# See License.txt for the text of the license.

# a little gadget that lets me quickly write message to the
# console for debugging.

import sys
from types import StringTypes

def em(msg): #pragma: no cover
    if msg[-1] != "\n":
        msg += "\n"
    sys.stderr.write(msg)

# a parameter parsing routine that's shared among all
# of the runners. Again, it's not anything really fancy,
# but it does allow turning options on and off, which
# is useful.

##def _doParms(obj, parmList):
##    posParms = []
##    errorMessages = []
##    j = 0
##    while j < len(parmList):
##        aParm = parmList[j]
##        if aParm[0] == "+":
##            setting = True
##        elif aParm[0] == "-":
##            setting = False
##        else:
##            break
##        i = 1
##        while i < len(aParm):
##            parmCode = aParm[i]
##            if obj.options.find(parmCode) == -1:
##                kind, varName = None, None
##            else:
##                kind, varName = obj._parmDict.get(parmCode, (None, None))
##            if kind == "s":
##                setattr(obj, varName, setting)
##            elif kind == "p":
##                setattr(obj, varName, parmList[j+1])
##                j += 1
##            else:
##                errorMessages.append("unrecognized option: '%s'\n"
##                                 % parmCode)
##            i += 1
##        j += 1
##    while j < len(parmList):
##        posParms.append(parmList[j])
##        j += 1
##    return errorMessages, posParms

# XXX DRY violation - I could build _strTable from _numList
class FitEnum(object):
    def __init__(self, parm):
        self.value = self._verifyParm(parm)

    def _verifyParm(self, parm):
        if isinstance(parm, StringTypes):
            value = self._strTable.get(parm.lower()[:3])
            if value is not None:
                return value
        elif (isinstance(parm, self.__class__)):
            return parm.value
        elif (isinstance(parm, int)):
            if 0 <= parm < len(self._strTable):
                return parm
        raise TypeError(self._typeErrorMessage(parm))

    def __eq__(self, other):
        return self.value == self._verifyParm(other)

    def __str__(self):
        return self._numList[self.value]