"""
Test fixture for table parameters.
Copyright 2004, John H. Roth Jr.
Released under the terms of the GNU General Public License version 2 or later.
"""

from fit.Fixture import Fixture
from fit.TypeAdapter import on as Adapter

class ParseExit(Fixture):

    def doRows(self, rows):
        Fixture.doRows(self, rows.more)

    def doCell(self, cell, column):
        if column == 0:
            self.adapter= Adapter(self, "aValue", {"aValue": cell.text().title()})
        elif column == 1:
            self.setUpExit(cell)
        elif column == 2:
            parsed = self.adapter.parse(cell.text())
            self.adapter.set(parsed)
        elif column == 3:
            if self.adapter.get() == cell.text():
                self.right(cell)
            else:
                self.wrong(cell, self.adapter.get())
        elif column == 4:
            self.setUpExit(cell)
        elif column == 5:
            expected = self.adapter.parse(cell.text())
            if self.adapter.equals(self.aValue, expected):
                self.right(cell,)
            else:
                self.wrong(cell, self.adapter.toString(self.aValue))
        else:
            return

    def setUpExit(self, cell):
        exitName = cell.text()
        if exitName == "":
            self.adapter.clearParseExit()
        else:
            exit = getattr(self, exitName) # does this get a bound method?
            self.adapter.setParseExit(exit)

    def reverse(self, value):
        aList = []
        for char in value:
            aList.append(char)
        aList.reverse()
        return "OK", "".join(aList)

    def sort(self, value):
        aList = []
        for char in value:
            aList.append(char)
        aList.sort()
        return "OK", "".join(aList)


