# Copyright (C) 2003 by Robert C. Martin and Micah D. Martin. All rights reserved.
# Released under the terms of the GNU General Public License version 2 or later.
# Converted to Python 2003/07/30 by John Roth

import sys, os

errlog = open("C:\Documents and Settings\John\My Documents\Projects\FitNew\Reports/FitFilterErrors.txt", "wt")
print >> errlog, "After open of errlog"
print >> errlog, ("initialization. len(argv): '%s' argv: '%s'" % (len(sys.argv), sys.argv))
print >> errlog, ("initialization. path: '%s'" % (sys.path,))
if len(sys.argv) >= 2:
    newPath = sys.argv[1].split(';')
    print >> errlog, ("new path components: '%s'" % (newPath,))
    sys.path[1:1] = newPath
print >> errlog, ("after assignment to path. new Path: '%s'" % (sys.path,))


from fit.Parse import Parse
from fit.Fixture import Fixture

class FitFilter:

    def __init__(self):    
        self.input = ""
        self.tables = None
        self.fixture = Fixture()
        self.output = sys.stdout

    def run(self, argv):
        self.args(argv)
        self.process()
        self.exit()

    def process(self):
##        print >> errlog, "in Process."
        try:
            self.tables = Parse(self.input)
            self.fixture.doTables(self.tables)
        except Exception, e:
##            print >> errlog, e
            print >> sys.stderr, e
##        print >> errlog, "before write to output"
        self.output.write(str(self.tables))

    def args(self, argv):
        if len(argv) not in (1, 2):
            print >> sys.stderr, "usage: python FitFilter.pyw"
            sys.exit(-1)
        try:
            self.input = self.read()
        except Exception, e:
##            print >> errlog, e
            print >> sys.stderr, e
            sys.exit(-1)

    def read(self):
        return sys.stdin.read()

    def exception(self, e):
        self.tables = Parse(tag="body", body="Unable to parse input. Input ignored.")
        self.fixture.exception(tables, e)

    def exit(self):
        os.close(2) # recommended in the "popen2" writeup
        sys.exit(self.fixture.counts.wrong + self.fixture.counts.exceptions)

if __name__ == "__main__":
    FitFilter().run(sys.argv)
