# test module for MusicPlayer2
# copyright 2005, John H. Roth Jr.
# Released under the terms of the GNU General Public License, Version 2.
# See license.txt for conditions and exclusion of all warrenties.

import sys
import unittest
from eg.MusicPlayer2 import EnglishListTypeAdapter, Song, TimeInSeconds
from fit.Utilities import em

try:
    False
except:
    True = 1
    False = 0

def makeMusicPlayer2Test():
    theSuite = unittest.TestSuite()
    theSuite.addTests([SpecifyEnglishListTypeAdapter(x) for x in [
                    "ListOfOneWord",
                    "ListOfTwoWordsWithAnd",
                    "ListOfThreeWordsWithOr",
                    "OneWordListToString",
                    ]])
    return theSuite

def _verifyMetaDataExists(obj, methodName):
    typeDict = getattr(obj, "_typeDict")
    metaData = typeDict[methodName + ".types"]
    return metaData is not None

class SpecifyEnglishListTypeAdapter(unittest.TestCase):
    def setUp(self):
        print '%s %s' % (self.id(), self.shortDescription())
        self.obj = EnglishListTypeAdapter()
        
    def ListOfOneWord(self):
        assert self.obj.parse("word") == ["word"]

    def ListOfTwoWordsWithAnd(self):
        assert self.obj.parse("stuff and bother") == ["stuff", "bother"]

    def ListOfThreeWordsWithOr(self):
        assert self.obj.parse("jam, jelly or marmellade") == ["jam",
                                        "jelly", "marmellade"]

    def OneWordListToString(self):
        assert self.obj.toString(["jam"]) == "jam"

if __name__ == '__main__':
    unittest.main(defaultTest='makeMusicPlayer2Test')
