#ActionFixtureUnderTest from FitLibrary
# Copyright 2003 and Developed by Rick Mugridge, University of Auckland, NZ
# Released under the terms of the GNU General Public License version 2 or later.
# Python translation copyright 2005, John H. Roth Jr.

# Note that a number of actions don't have metadata. This is because
# neither the start nor press actions require metadata. Also, there
# are a couple of invalid methods that there is no way to enter
# metadata for in the current structure.


# !!! WARNING ---- There is an import loop between this fixture and
# Another Actor. The import for Another Actor has been moved to the
# bottom.

from fit.ActionFixture import ActionFixture
from fit.Fixture import Fixture

try:
    False
except:
    False = 0
    True = 1

class ActionFixtureUnderTest(Fixture):
    _typeDict = {"result": "Integer"}
    result = 0

    _typeDict["pressMethod"] = "Boolean"
    def pressMethod(self): # methods using invoke need metadata as of 0.8
        pass

    _typeDict["enterString"] = "String"
    def enterString(self, s):
        pass

    _typeDict["enterResult"] = "Int"    
    def enterResult(self, result):
        self.result = result

    _typeDict["intResultMethod"] = "Int"
    def intResultMethod(self):
        return self.result

    _typeDict["booleanResultMethod"] = "Boolean"
    def booleanResultMethod(self):
        return False

    _typeDict["enterThrows"] = "String"
    def enterThrows(self, s):
        raise Exception, "this is a test"

    def pressThrows(self):
        raise Exception, "this is a test"

    _typeDict["checkThrows"] = "String"
    def checkThrows(self):
        raise Exception, "this is a test"

    _typeDict["pressMethodReturningInt"] = "Integer"
    def  pressMethodReturningInt(self):
        return 123

    def enterMethodWithNoArgs(self):
        pass

    def enterMethodWithTwoArgs(self, a, b):
        pass

    _typeDict["switchActor"] = "Boolean"
    def switchActor(self):
        ActionFixture.actor = AnotherActor(self)

from fitLib.specify.AnotherActor import AnotherActor
