# DoTree from FitLibrary Specification Tests
# Developed by Rick Mugridge
# copyright 2004 Rick Mugridge University of Auckland, NZ
# Released under the terms of the GNU General Public License, version 2 or later
# Translation to Python copyright 2005, John H. Roth Jr.

from fitLib.DoFixture import DoFixture
from fitLib.ListTree import ListTree, Tree, TreeTypeAdapter

class DoTree(DoFixture):
    _typeDict = {}

    _typeDict["tree.types"] = [TreeTypeAdapter, "String"]
    def tree(self, aString = None):
        if aString is None:
            aTree = ListTree("")
            aTree.addChild(ListTree("a"))
            aTree.addChild(ListTree("BB"))
            return aTree
        else:
            return ListTree.parse(aString)        

    _typeDict["teeTree.types"] = [TreeTypeAdapter, TreeTypeAdapter]
    def teeTree(self, t):
        return t

    _typeDict["it.types"] = [TreeTypeAdapter]
    def it(self):
        return TeeTree(self.tree())

class TeeTree(ListTree): # implements Tree, TreeInterface {
    _typeDict = {"tree": TreeTypeAdapter}    
    tree = None # tree

    def __init__(self, tree):
        self.tree = ListTree("B", tree.getChildren())

    _typeDict["title.RenameTo"] = "getTitle"
    _typeDict["getTitle.types"] = ["String"]
    def getTitle(self):
        return self.tree.getTitle()

#    _typeDict["text.RenameTo"] = "getText"
    _typeDict["getText.types"] = ["String"]
    def getText(self):
        return self.tree.getText()

    _typeDict["children.RenameTo"] = "getChildren"
    _typeDict["getChildren.types"] = [TreeTypeAdapter] # ???
    def getChildren(self):
       return self.tree.getChildren()

    _typeDict["text.types"] = ["String"]
    def text(self):
        return self.tree.textToString()

    _typeDict["parseTree.types"] = [TreeTypeAdapter, "String"]
    def parseTree(self, tree):
        return TeeTree(tree)

    _typeDict["toString.types"] = ["String"]
    def toString(self):
        return self.tree.toString()

    _typeDict["toTree.types"] = [TreeTypeAdapter]
    def toTree(self):
        return self.tree

